<a data-toggle="modal" href="#edit_city" class="" id="edit_city_link"></a>        
<div id="page-content">
    <div id='wrap'>
        <div id="page-heading">
            <?php $this->Html->addCrumb('City', '');?>
            <h1>Cities</h1>
            <div class="options">
                <div class="btn-toolbar">
                    <div class="btn-group hidden-xs">
                        <?php echo $this->Html->link("Sort by Default",array("action"=>"index"),array("class"=>"btn btn-default"));?>
                	</div>
                    <div class="btn-group hidden-xs">
                        <a data-toggle="modal" class="btn btn-default" href="#myModal"><span class="hidden-sm"> Add New City</a>
                	</div>
               	</div>
           	</div>
        </div>
            <div class="container">
            <div class="row">
                <div class="col-sm-12">            
                    <div class="panel panel-sky">
                      <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>S. No.</th>
                                        <th><?php echo $this->Paginator->sort('title','City Name');?></th>
                                        <th><?php echo __('Actions');?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                	<?php
									$i=1;
									foreach ($cities as $city){ 
									?>
                                    <tr>
                                        <td align="left"><i><?php echo $i;?></i></td>
                                        <td><?php echo $city['City']['title'];?></td>
                                        <td><a title="View/Edit" onclick="edit_city('<?php echo $city['City']['id'];?>')" class=""><i class="fa fa-edit"></i></a>
					<?php echo $this->Form->postLink(__('', true), array('action' => 'delete', $city['City']['id']), array('class'=>'fa fa-trash-o','title'=>'Delete'), __(DELETE_CONFIRM)); ?></td>
                                    </tr>
                                    <?php $i++;}?>
                                </tbody>
                            </table>
                        </div>
                        <div id="dompaginate" class="tab-pane active">
                                <ul class="pagination"><?php 
                            $hasPages = ($this->params['paging']['City']['pageCount']);
                            if ($hasPages > 1){?>
                            <?php $this->Paginator->options(array(/*'url' =>  $pagingArgs*/)); ?>
                            <li class=""><?php echo $this->Paginator->prev( __(''), array('class' => 'fa fa-angle-double-left'), null, array('class' => 'fa fa-angle-double-left')); ?></li>			
                            <?php echo $this->Paginator->numbers(array('separator'=>'','tag'=>'li')); ?><li class=""><?php echo $this->Paginator->next(__(''), array('class' => 'fa fa-angle-double-right'), null, array('class' => 'fa fa-angle-double-right')); ?></li>
                            </ul>
                            <?php  } ?>
                            <div class="num_records">
								<?php echo $this->Paginator->counter(array(
                                    'format' => 'range'
                                ));?>
                            </div>
                        </div>
                      </div>
                    </div>
                </div>
            </div>
       	</div>
  	</div>
</div>
<div id="myModal" tabindex="-1" role="dialog" class="modal fade">
    <div class="modal-dialog">
    	<?php echo $this->Form->create('City', array('type' => 'file','name'=>'city','url' => array('controller' => 'cities','action' => 'add'),'onSubmit' =>'return validation()')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><i class="icon-hdd"></i> Add new city</h4>
            </div>
            <div class="modal-body">
                 <div class="module_content">
                    <fieldset class="left_fieldset">
                    	<label>Title <span class="required_sign">*</span></label>
                        <div class="generic-width">
                        <?php echo $this->Form->input('City.title',array('id'=>'addCityTitle','label' => false,'div' => false,"class"=>'form-control','placeholder'=>'Enter title of city'));?>
                        </div>
                    </fieldset>
                    <div class="clear"></div>
             	</div>
            </div>
            <div class="modal-footer">
                 <?php echo $this->Form->submit('Save', array('class'=>"btn btn-lg btn-primary",'div' => false, 'title' => 'Save'));?>
               	<button type="button" class="btn btn-lg btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
        <?php echo $this->Form->end();?>
        <!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
<link rel="stylesheet" href="http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css" />
<script src="http://code.jquery.com/ui/1.10.3/jquery-ui.js"></script>
</div><!-- /.modal -->
<div id="edit_city" tabindex="-1" role="dialog" class="modal fade"></div>
<!---->
<?php echo $this->Html->script(array('scripts/bootstrap.min','scripts/main','scripts/common'));?>
<script type="text/javascript">
$().ready(function() { 
	$(".modal").css("display","none");
});
</script>
<script>
function validation()
{
	var errMessage = "";
	if($("#addCityTitle").val() =='')
	{
		errMessage += "* Please enter city title.\n";
	}
	if (errMessage != "")
	{
		var allerror="The required information is incomplete or contains errors:\n\n";
		errMessage=allerror + errMessage;
		alert(errMessage);
		return false;
	}
	else
	{
		return true;
	}
}
function edit_city(city_id) {
	$('#edit_city').html('');
	data="";
	$.ajax({
		url: "<?php echo Configure::read('Site.Url');?>admin/cities/edit/"+city_id,
		type: "GET",	
		cache: false,
		success: function (html) {	
			$('#edit_city').html(html);
			$("#edit_city_link").click();
		}		
	});	 
}
</script>