<?php
App::uses('AppModel', 'Model');
class EmailTemplate extends AppModel {
	var $name = 'EmailTemplate';
	public $validate = array(
		'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter name.',
			),
		),
		'from' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter from.',
			),
		),
		'subject' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter subject.',
			),
		),
		'email_content' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter Email Content.',
			),
		),
	);
	
	function selectTemplate($tempName) 
    {
        $emailTemplate = $this->find('first', array(
            'conditions' => array(
                'EmailTemplate.name' => $tempName
            ) ,
            'fields' => array(
                'EmailTemplate.email_content',
                'EmailTemplate.subject',
                'EmailTemplate.from',
                'EmailTemplate.reply_to',
                'EmailTemplate.is_html',
				'EmailTemplate.status'
            ) ,
            'recursive' => -1
        ));
        $resultArray = array();
        foreach($emailTemplate as $singleArrayEmailTemplate) {
            foreach($singleArrayEmailTemplate as $key => $value) {
                $resultArray[$key] = $value;
            }
        }
        return $resultArray;
    }
}
