<?php
App::uses('AppController', 'Controller');
class SiteBackupsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('SiteBackup','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'SiteBackup.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->SiteBackup->recursive = 0;
		//pr($this->data);die;
		if(isset($this->data['SiteBackup']['title']) && $this->data['SiteBackup']['title']!='') $title = $this->data['SiteBackup']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['SiteBackup']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['SiteBackup.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('SiteBackup.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('site_backups', $rows);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->SiteBackup->id = $id;
		if (!$this->SiteBackup->exists()) {
			throw new NotFoundException(__('Invalid Backup'));
		}
		else
		{
			$data = $this->SiteBackup->read(null, $id);
			unlink('/home/worldtra/public_html/link_management/app/webroot/backup/'.$data['SiteBackup']['title']);
			if ($this->SiteBackup->delete()) {
				$this->Session->setFlash(__('Backup has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Backup could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
