<?php
App::uses('AppController', 'Controller');
class InternetManagementsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('InternetManagement','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'InternetManagement.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($dir=NULL,$count_total=NULL)
	{
		$this->checkAdmin();
		if(empty($dir))
		{
			$dir=WWW_ROOT.'url';
			$count_total=0;
		}
		$ffs = scandir($dir);

		unset($ffs[array_search('.', $ffs, true)]);
		unset($ffs[array_search('..', $ffs, true)]);
		
		// prevent empty ordered elements
		if (count($ffs) < 1)
			return;
		$arr=array();
		foreach($ffs as $folder_name){
			$title_arr=explode(".",$folder_name);
			$extenxion=end($title_arr);
			
			$count=$this->InternetManagement->find("count",array("conditions"=>array("InternetManagement.url"=>$folder_name)));
			if($count==0)
			{
				$arr['id']='';
				$arr['url']=$folder_name;
				$arr['date_time']=date("Y-m-d H:i:s");
				$res1=$this->InternetManagement->save($arr);
				$count_total++;
			}
			if(is_dir($dir.'/'.$folder_name)) $this->admin_index($dir.'/'.$folder_name,$count_total);
		}
		$this->set("count_total",$count_total);
	}
	
	public function admin_google_search($dir=NULL,$count_total=NULL)
	{
		$this->checkAdmin();
		$results=$this->InternetManagement->find("all",array());
		
		$namedate=__("Google Search")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Google Search");
		$sep = ", ";
		$array_key=array(__("URL"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($results as $result)
		{			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$result['InternetManagement']['url'])).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
			$arr['id']='';
			$arr['url']=$folder_name;
			$arr['date_time']=date("Y-m-d H:i:s");
			$this->InternetManagement->save($arr);
		}
		exit;
	}
	public function admin_listing()
	{
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->InternetManagement->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='DeActive')
				$this->InternetManagement->updateAll(array("InternetManagement.status"=>'0'),array("InternetManagement.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				$this->InternetManagement->updateAll(array("InternetManagement.status"=>'1'),array("InternetManagement.id"=>$this->request->data['frmList']['ID']));
				foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$this->add_site_data($userid);
				}
			}
			else if($this->request->data['task_value']=='Delete')
			{
				$this->InternetManagement->deleteAll(array('InternetManagement.id' => $this->request->data['frmList']['ID']), false);
				$this->Session->setFlash(__('Employee Email has been deleted successfully.'), 'default', array('class' => 'success'));
			}
		}
		
		if(isset($this->data['InternetManagement']['search_type_id']) && $this->data['InternetManagement']['search_type_id']!='') $search_type_id = $this->request->data['InternetManagement']['search_type_id'];	
		else if(isset($this->params['named']['search_type_id']) && $this->params['named']['search_type_id']!='') $search_type_id = $this->request->data['InternetManagement']['search_type_id']=$this->params['named']['search_type_id'];	
		
		if(isset($this->data['InternetManagement']['url']) && $this->data['InternetManagement']['url']!='') $url = $this->data['InternetManagement']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url =$this->request->data['InternetManagement']['url']=$this->params['named']['url'];
		
		//echo '<pre>';print_r($this->data['InternetManagement']);
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($search_type_id))
		{
			$conditions['InternetManagement.search_type_id'] = $search_type_id;
			$pagingArgs['search_type_id'] = $search_type_id;
		}
		if(!empty($url))
		{
			$conditions['InternetManagement.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		//echo '<pre>';print_r($conditions);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('InternetManagement.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		$this->set('internet_managements', $rows);
	}
	public function admin_internet_csv()
	{
		//Configure::write('debug',0);
		$this->checkSubAdmin();	
		if ($this->request->is('post')) {
						
			if (($handle = fopen($this->request->data['InternetManagement']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
			$search_type_id=$this->request->data['InternetManagement']['search_type_id']	;	
			$namedate=__("Internet-Management")."-".date("m.d.y");
			$file_type = "vnd.ms-excel";
			$file_ending = "csv";
			header("Content-Type: application/$file_type");
			header("Content-Disposition: attachment; filename=$namedate.$file_ending");
			header("Pragma: no-cache");
			header("Expires: 0");
			$title = __("Internet Management");
			$sep = ", ";
			$array_key=array(__("URL"));
			for ($i = 0; $i < count($array_key); $i++)
			{
				echo $array_key[$i] . ", ";
			}
					print("\n");
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				 if($count==1)
				 {
					$count++;
				 	continue;
				 }
				$arr['id']='';
				$siteurl=trim($data[0]);
				$siteurl=trim($siteurl,'/');
				$siteurl=str_replace('http://','',$siteurl);
				$siteurl=str_replace('https://','',$siteurl);
				$siteurl=str_replace('www.','',$siteurl);
				$siteurl_arr=explode('/',$siteurl);
				$siteurl=$siteurl_arr[0];
				
				$check_unique=$this->InternetManagement->find("first",array("conditions"=>array("InternetManagement.url LIKE"=>'%'.$siteurl.'%',"InternetManagement.search_type_id"=>$search_type_id)));
				 if(empty($check_unique))
				 {
					$schema_insert = "";
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$siteurl)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ','not found')).$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
					$schema_insert .= "\t";
					print(trim($schema_insert));
					print "\n";
					
					$ins_arr['id']='';
					$ins_arr['search_type_id']=$search_type_id;
					$ins_arr['url']=$siteurl;
					$ins_arr['date_time']=date("Y-m-d H:i:s");
					$this->InternetManagement->save($ins_arr);
					
				 }
			  }
			  fclose($handle);
					exit;
			}
		}
	
	}
	public function admin_download_csv()
	{
		$this->checkSubAdmin();
		Configure::write('debug',0);
		$this->autoRender = false;
		$this->InternetManagement->recursive = 0;
		
		if(isset($this->data['download']['search_search_type_id']) && $this->data['download']['search_search_type_id']!='') $search_type_id = $this->data['download']['search_search_type_id'];	
		else if(isset($this->params['named']['search_type_id']) && $this->params['named']['search_type_id']!='') $search_type_id = $this->data['InternetManagement']['search_type_id']=$this->params['named']['search_type_id'];	
		
		if(isset($this->data['download']['search_url']) && $this->data['download']['search_url']!='') $url = $this->data['download']['search_url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->data['InternetManagement']['url']=$this->params['named']['url'];
		
		
		$conditions = array(); 
		$pagingArgs = array(); 
		if(!empty($search_type_id))
		{
			$conditions['InternetManagement.search_type_id'] = $search_type_id;
		}
		if(!empty($url))
		{
			$conditions['InternetManagement.url LIKE '] = '%'.$url.'%';
		}
		
		$rows = $this->InternetManagement->find("all",array('order'=>array('InternetManagement.id'=>'DESC'),'conditions'=>$conditions));
		
		$namedate=__("Internet-Management")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Internet-Management");
		$sep = ", ";
		$array_key=array(__("Search Type"),__("URL"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($rows as $employee_emails)
		{
			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_search_type($employee_emails['InternetManagement']['search_type_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['InternetManagement']['url'])).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
		}
		exit;
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->InternetManagement->id = $id;
		if (!$this->InternetManagement->exists()) {
			throw new NotFoundException(__('Invalid Internet Management'));
		}
		else
		{
			if ($this->InternetManagement->delete()) {
				$this->Session->setFlash(__('Internet Management has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'listing'));
			}
		}
		$this->Session->setFlash(__('Internet Management could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'listing'));
	}
}
