<?php
App::uses('AppController', 'Controller');
class HomePageLinkDurationsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('HomePageLinkDuration','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'HomePageLinkDuration.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->HomePageLinkDuration->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->HomePageLinkDuration->updateAll(array("HomePageLinkDuration.status"=>'0'),array("HomePageLinkDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->HomePageLinkDuration->updateAll(array("HomePageLinkDuration.status"=>'1'),array("HomePageLinkDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->HomePageLinkDuration->updateAll(array("HomePageLinkDuration.show_home"=>'1'),array("HomePageLinkDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->HomePageLinkDuration->updateAll(array("HomePageLinkDuration.show_home"=>'0'),array("HomePageLinkDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->HomePageLinkDuration->deleteAll(array('HomePageLinkDuration.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['HomePageLinkDuration']['title']) && $this->data['HomePageLinkDuration']['title']!='') $title = $this->data['HomePageLinkDuration']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['HomePageLinkDuration']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['HomePageLinkDuration.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('HomePageLinkDuration.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('home_page_link_durations', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add HomePageLinkDuration'));
		if ($this->request->is('post')) {
			$this->HomePageLinkDuration->create();	
			$pre_title_check = $this->HomePageLinkDuration->find("count",array("conditions"=>array("HomePageLinkDuration.title"=>$this->request->data['HomePageLinkDuration']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['HomePageLinkDuration']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->HomePageLinkDuration->save($this->request->data['HomePageLinkDuration'])){
					$this->Session->setFlash(__('Home Page Link Duration has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Home Page Link Duration could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Home Page Link Duration title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit HomePageLinkDuration'));
		$this->HomePageLinkDuration->id = $id;
		$selected = "";
		
		$driver_detail = $this->HomePageLinkDuration->find("first",array("conditions"=>array("HomePageLinkDuration.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->HomePageLinkDuration->exists()) {
			throw new NotFoundException(__('Invalid home_page_link_duration'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['HomePageLinkDuration']['id']=$id;		
			$pre_title_check = $this->HomePageLinkDuration->find("count",array("conditions"=>array("HomePageLinkDuration.title"=>$this->request->data['HomePageLinkDuration']['title'],"HomePageLinkDuration.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->HomePageLinkDuration->saveAll($this->request->data['HomePageLinkDuration'])) {
					$this->Session->setFlash(__('Home Page Link Duration has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Home Page Link Duration could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Home Page Link Duration title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->HomePageLinkDuration->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->HomePageLinkDuration->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->HomePageLinkDuration->id = $id;
		if (!$this->HomePageLinkDuration->exists()) {
			throw new NotFoundException(__('Invalid Home Page Link Duration'));
		}
		else
		{
			if ($this->HomePageLinkDuration->delete()) {
				$this->Session->setFlash(__('Home Page Link Duration has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Home Page Link Duration could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
