<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different urls to chosen controllers and their actions (functions).
 *
 * PHP 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/View/Pages/home.ctp)...
 */
 
	Router::connect('/', array('controller' => 'pages', 'action' => 'view'));
	Router::connect('/admin', array('admin' => true, 'controller' => 'users', 'action' => 'login'));
	/*Router::connect(
        '/services/*', array('controller' => 'services', 'action' => 'index'), array(
            'params' => array('query'),
            'named' => array(
                'query'
            )
        )
    );*/
	Router::connect(
        '/page/:slug', array('controller' => 'pages', 'action' => 'index'),array('slug' => '[0-9 a-z A-Z _ + -]+')
    );
	Router::parseExtensions();
	Router::parseExtensions('json');
	/*App::uses('SubdomainRoute', 'Lib');
	$ops = array('routeClass' => 'SubdomainRoute'); 
	Router::connect('/:subdomain/', array('controller'=>'pages','action' => 'view'),$ops);*/
	
		
	Router::connect('/page/:pagename', array(
            'controller' => 'pages',
            'action' => 'index'
                ), array('pagename' => '[0-9 a-z A-Z _ + -]+')
      );
	  
	 Router::connect(
            '/site_page/:tag',
            array(
                'controller' => 'pages',
                'action' => 'site_page',
                'admin'=>false
            ),
            array(
                'pass' => array(
                    'tag'
                )
            )
         ); 
		 
		 
/**
 * ...and connect the rest of 'Pages' controller's urls.
 */
	//Router::connect('/users/*', array('controller' => 'users', 'action' => 'index'));
	//Router::connect('/admin/*', array('controller' => 'users', 'action' => 'index', 'admin' => true));
	//Router::connect('/admin/:controller/:action/*', array('action' => null, 'prefix' => 'admin', 'admin' => true, 'layout' => 'admin_default' ));

/**
 * Load all plugin routes.  See the CakePlugin documentation on 
 * how to customize the loading of plugin routes.
 */
	CakePlugin::routes();

/**
 * Load the CakePHP default routes. Remove this if you do not want to use
 * the built-in default routes.
 */
	require CAKE . 'Config' . DS . 'routes.php';