/*!

 *

 * SPLITSCREEN - Fullscreen and Miniscreen Dual Page Splitting jQuery Plugin

 * URL: http://www.codecanyon.net/user/d8n

 * Version: 1.5.0

 * Author: Daton Lynch

 * Author URL: http://www.codecanyon.net/user/d8n

 * Copyright  2011

 * All rights reserved.

 *

 *

 * HOW TO OPEN SPLITSCREEN EXTERNALLY:

 *

 * (A) To open SPLITSCREEN via javascript call, use this function: $.openSplitscreen('#divName');

 *     The 'divName' is the name of the splitscreen div you seek to open;

 *

 *     FOR EXAMPLE: <a href="#" onclick="$.openSplitscreen('#demo')">Open the Splitscreen with div id 'demo'</a>

 *

 *  

 * HOW TO CLOSE SPLITSCREEN EXTERNALLY:

 *

 * (A) To close SPLITSCREEN via javascript call, use this function: $.closeSplitscreen('#divName');

 *     The 'divName' is the name of the splitscreen div you seek to close;

 *

 *     FOR EXAMPLE: <a href="#" onclick="$.destroySplitscreen('#demo')">Dismiss the Splitscreen with div id 'demo'</a>

 * 

 * (B) When using TEASER MODE: To close SPLITSCREEN via link, add the 'c-splitscreen' class to your link.

 * 

 *     FOR EXAMPLE: <a href="#" class="c-splitscreen">Close this Splitscreen</a>

 *

 *  

 * HOW TO DISMISS SPLITSCREEN EXTERNALLY:

 *

 * (A) To dismiss SPLITSCREEN via javascript call, use this function: $.destroySplitscreen('#divName');

 *     The 'divName' is the name of the splitscreen div you seek to dismiss;

 *

 *     FOR EXAMPLE: <a href="#" onclick="$.destroySplitscreen('#demo')">Dismiss the Splitscreen with div id 'demo'</a>

 * 

 * (B) When using TEASER MODE: To dismiss SPLITSCREEN via link, add the 'x-splitscreen' class to your link.

 * 

 *     FOR EXAMPLE: <a href="#" class="x-splitscreen">Destroy Splitscreen</a>

 *

 *

 **/

(function($){

		/**

		* Start jQuery Cookie routine

		*

		* Copyright (c) 2010 Klaus Hartl (stilbuero.de)

		* Dual licensed under the MIT and GPL licenses:

		* http://www.opensource.org/licenses/mit-license.php

		* http://www.gnu.org/licenses/gpl.html

		*

		**/		

		jQuery.cookie = function (key, value, options) {

			if (arguments.length > 1 && String(value) !== "[object Object]") {

				options = jQuery.extend({}, options);

				if (value === null || value === undefined) {

					options.expires = -1;

				}

				if (typeof options.expires === 'number') {

					var days = options.expires, t = options.expires = new Date();

					t.setDate(t.getDate() + days);

				}

				value = String(value);

				return (document.cookie = [

					encodeURIComponent(key), '=',

					options.raw ? value : encodeURIComponent(value),

					options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE

					options.path ? '; path=' + options.path : '',

					options.domain ? '; domain=' + options.domain : '',

					options.secure ? '; secure' : ''

				].join(''));

			}

			options = value || {};

			var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;

			return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;

		};

		/** End jQuery Cookie routine */		

	

		function showOption(settingName){

			if (settingName === false){

				return 'display:none;';

			}else{

				return 'display:block;';

				}	

			}

			

		function showOptionBtn(settingName){

			if (settingName === false){

				return 'display:none;';

			}else{

				return 'display:inline-block;';

				}	

			}

			

		function showLinkHint(settingName, button, value){ 

			if (settingName === true && button == "promo"){

				return 'title="'+ value +'"';

			}else if (settingName === true && button == "continue"){

				return 'title="'+ value +'"';

				}	

			if (settingName === false){

				return;

				}	

			}



	$.fn.splitscreen=function(options){

		defaults = {

		

		//See 'Configuration Options' in the User guide for parameter info.

		

		/* Mode */

		splitMode:		'splash',

		cookieName:		'splitscreen',

		

		/* Appearance */

		fullscreen:	true,

		horizontal: false,

		splitPercent: '25%',

		noClick: false, // if true, disables clicking on the splitscreen /* New */

		onlyClick: false, // if true, splitscreen only opens if clicked /* New */

		

		/* True or False */

		cookieOn:			false,				 			

		showPromoBtn:		true,				

		showContinueBtn:	true, 						

		showFade:			true,

		showShadow:			true,

		showRaster:			true, 		

		showCenter:			true, 		

		showCenterTop:		false, 	    

		showCenterBottom:	false, 	    		

		showFloatRightTop:    false,	

		showFloatRightCenter: false,	

		showFloatRightBottom: false,			

		showFloatLeftTop:     false,	

		showFloatLeftCenter:  false,	

		showFloatLeftBottom:  false,					

		showUnderlay:		true,					

		showIntroSplit:		true, 				

		showAutoSplit:		true,

		showDismissSplit: false,

		showHints:			false, 				



		/* Timer */

		splitTimeIntro: 	2000, 		

		splitTimeAuto:		15000,

		splitTimeDismiss: 20000,

		splitDismissDuration: 5000, // Determines How Long the dismiss split lasts /* New */



		/* Images */		

		imageDir: 			'd8n-splitscreen/img/',		

		imageBG:			'background-3.jpg', 	

		imageWidthBG: 		1920, 				

		imageHeightBG:		1080, 						

		imageRaster:		'raster00.png', 	

		alphaRaster:		'80', 					

		imageCenter:		'logo-large.png',

		imageFloating:		'logo-large.png',				

		imageFadeLeft:		'fade-left.png',	

		imageFadeRight:		'fade-right.png',

		imageFadeTop:		'fade-top.png',	

		imageFadeBottom:	'fade-bottom.png',		

		imageLoading:		'loader-white.gif',	

		imageLoadingBG: 	'#000000',			

		

		/* Align Teaser */

		verticalAlignTeaser:	'middle',		 		



		/* Align Buttons*/

		verticalAlignBtn:	'middle',			

		

		/* Continue button */		

		textContinueBtn:		'Continue to site &raquo;', 

		colorContinueTxt:		'#ffffff', 					

		fontContinueTxt:		'Georgia1, Georgia, serif',

		styleContinueTxt:		'normal',

		boldContinueTxt:		'bold',

		sizeContinueBtn:		'14px',						

		colorContinueBtn:		'#333333',					

		colorContinueRoll:		'#999999',					

		

		/* Promo button */

		textPromoBtn:		'Build Something Too &raquo;',	

		colorPromoTxt:		'#ffffff', 													

		fontPromoTxt:		'Georgia1, Georgia, serif',

		stylePromoTxt:		'italic',

		boldPromoTxt:		'normal',

		sizePromoBtn:		'18px',													 	

		colorPromoBtn:		'#cc0000',													

		colorPromoRoll:		'#ff0000',														

		urlPromoBtn:		'http://www.google.com',									

		targetPromoBtn:		'_blank',

		spacePromoBtn:		'<br /><br />',



		/* Underlay */

		colorUnderlay:			'#000000',			

		alphaUnderlay:			'95'

			};

			

		return this.each(function(){

			settings = $.extend({},defaults,options);

			$.splitscreenInstanceCreater(this,options);		

			});

		};

	

	$.splitscreenInstanceCreater=function(target,options){

		return target.splitscreen || (target.splitscreen=new $.splitscreenInstance(target,options));

		};		



	$.splitscreenInstance=function(target,options){



		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/	

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/* COOKIE CHECK */

		/*--------------------------------------------------------------*/				



		$.splitscreenCookie = $.cookie(settings.cookieName);

	

		if(settings.cookieOn === true && $.splitscreenCookie === null || settings.cookieOn === false){

			if(settings.cookieOn === true){$.cookie(settings.cookieName, settings.cookieName);}	



		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/				

			

			/*--------------------------*/

			/* SPLITSCREEN HTML         */

			/*--------------------------*/

			

			// Splash Html

			if(settings.splitMode == 'splash'){		

			$.splitscreenHtml = 

				'<!--[ START SPLITSCREEN ]-->' +

				'<div class="splitscreen-load-mask" style="background:'+ settings.imageLoadingBG  +' url('+ settings.imageDir + settings.imageLoading +') center center no-repeat;"></div>' +

				'<div class="splitscreen">' +

					'<!--[ SPLIT SCREEN ]-->' +

					'<div class="splitscreen-main splitscreen-erase">' +

						'<div class="splitscreen-activate x-splitscreen splitscreen-erase"></div>' +

						'<div class="splitscreen-fade-left splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-fade-right splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-left splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-left">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-left main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';

	

						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';				

							} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>';							

								}

							

						$.splitscreenHtml = $.splitscreenHtml +	

						'</div>' +



						'<div class="splitscreen-right splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-right">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-right main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';



						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +						

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';							

							} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>';

								}



						$.splitscreenHtml = $.splitscreenHtml +	

						'</div>' +

						'<div class="splitscreen-shadow-left splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +		

						'</div>' +

						'<div class="splitscreen-shadow-right splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +							

						'</div>' +				

						'<!--[ UNDERLAY ]-->' +

						'<div class="splitscreen-underlay splitscreen-erase-fade" style="background:'+ settings.colorUnderlay +'; filter:alpha(opacity='+ settings.alphaUnderlay +'); -moz-opacity:0.'+ settings.alphaUnderlay +'; opacity:0.'+ settings.alphaUnderlay +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaUnderlay +'); '+ showOption(settings.showUnderlay) +';"></div>' +		

					'</div>' +

				'</div>' +

				'<!--[ STOP SPLITSCREEN ]-->';

				}

			

			// Promo Html

			if(settings.splitMode == 'promo'){

			$.splitscreenHtml = 			

				'<style type="text/css">' +	

				'.awesome-promo, .awesome-promo:visited {background-color:'+ settings.colorPromoBtn +';}' +

				'.awesome-promo:hover {background-color:'+ settings.colorPromoRoll +';}' +

				'.awesome-continue, .awesome-continue:visited {background-color:'+ settings.colorContinueBtn +';}' +

				'.awesome-continue:hover {background-color:'+ settings.colorContinueRoll +';}' +	

				'</style>' +			

				'<!--[ START SPLITSCREEN ]-->' +

				'<div class="splitscreen-load-mask" style="background:'+ settings.imageLoadingBG  +' url('+ settings.imageDir + settings.imageLoading +') center center no-repeat;"></div>' +

				'<div class="splitscreen">' +

					'<!--[ SPLIT SCREEN ]-->' +

					'<div class="splitscreen-main splitscreen-erase">' +

						'<div class="splitscreen-activate splitscreen-erase"></div>' +

						'<div class="splitscreen-activate-2 splitscreen-erase"></div>' +

						'<div class="splitscreen-fade-left splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-fade-right splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-left splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-left">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-left main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';			



						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';				

							} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>';							

								}

							

						$.splitscreenHtml = $.splitscreenHtml +	

						'</div>' +

						

						'<div class="splitscreen-right splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-right">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-right main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';



						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +						

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';							

							} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>';

								}



						$.splitscreenHtml = $.splitscreenHtml +						

						'</div>' +

						'<div class="splitscreen-shadow-left splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +		

						'</div>' +

						'<div class="splitscreen-shadow-right splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +							

						'</div>' +											

						'<!--[ UNDERLAY ]-->' +

						'<div class="splitscreen-underlay splitscreen-erase-fade" style="background:'+ settings.colorUnderlay +'; filter:alpha(opacity='+ settings.alphaUnderlay +'); -moz-opacity:0.'+ settings.alphaUnderlay +'; opacity:0.'+ settings.alphaUnderlay +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaUnderlay +'); '+ showOption(settings.showUnderlay) +';">' +

						'</div>' +						

						'<div class="splitscreen-button-div">' +

							'<table class="splitscreen-button-holder" cellpadding="0" cellspacing="0"><tbody><td align="center" valign="'+ settings.verticalAlignBtn +'">' +

							'<a href="'+ settings.urlPromoBtn +'" target="'+ settings.targetPromoBtn +'" class="' + settings.sizePromoBtn + ' awesome awesome-promo" '+ showLinkHint(settings.showHints, "promo", settings.textPromoBtn) +' style="font-size:'+ settings.sizePromoBtn +'; font-weight:'+ settings.boldPromoTxt +'; font-style:'+ settings.stylePromoTxt +'; font-family:'+ settings.fontPromoTxt +'; color:'+ settings.colorPromoTxt +'; '+ showOptionBtn(settings.showPromoBtn) +'">'+ settings.textPromoBtn +'</a>' +

							''+settings.spacePromoBtn+'' +

							'<a class="x-splitscreen ' + settings.sizeContinueBtn + ' awesome awesome-continue" '+ showLinkHint(settings.showHints, "continue", settings.textContinueBtn) +' style="font-size:'+ settings.sizeContinueBtn +'; font-weight:'+ settings.boldContinueTxt +'; font-style:'+ settings.styleContinueTxt +'; font-family:'+ settings.fontContinueTxt +'; color:'+ settings.colorContinueTxt +'; '+ showOptionBtn(settings.showContinueBtn) +'">'+ settings.textContinueBtn +'</a>' +

							'</td></tbody></table>' +

						'</div>' +						

					'</div>' +

				'</div>' +

				'<!--[ STOP SPLITSCREEN ]-->';

				}			



			// Teaser Html

			if(settings.splitMode == 'teaser'){				

			$.splitscreenHtml = 

				'<!--[ START SPLITSCREEN ]-->' +

				'<div class="splitscreen-load-mask" style="background:'+ settings.imageLoadingBG  +' url('+ settings.imageDir + settings.imageLoading +') center center no-repeat;"></div>' +

				'<div class="splitscreen">' +

					'<!--[ SPLIT SCREEN ]-->' +

					'<div class="splitscreen-main splitscreen-erase">' +

						'<div class="splitscreen-activate splitscreen-erase"></div>' +

						'<div class="splitscreen-activate-2 splitscreen-erase"></div>' +

						'<div class="splitscreen-fade-left splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-fade-right splitscreen-erase splitscreen-sector"></div>' +

						'<div class="splitscreen-left splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-left">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-left main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';

	

						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo-left splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';				

						} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left top no-repeat; '+ showOption(settings.showFloatLeftTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>';							

							}

							

						$.splitscreenHtml = $.splitscreenHtml +	

						'</div>' +

						'<div class="splitscreen-right splitscreen-erase splitscreen-sector">' +

							'<div class="splitscreen-bg-right">' +

								'<img src="'+ settings.imageDir + settings.imageBG +'" width="'+ settings.imageWidthBG +'" height="'+ settings.imageHeightBG +'" class="splitscreen-fullscreen" />' +

								'<div class="splitscreen-raster-right main-raster" style="background:transparent url('+ settings.imageDir + settings.imageRaster +') 0 0; '+ showOption(settings.showRaster) +' filter:alpha(opacity='+ settings.alphaRaster +'); -moz-opacity:0.'+ settings.alphaRaster +'; opacity:0.'+ settings.alphaRaster +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaRaster +');"></div>' +

							'</div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center top no-repeat; '+ showOption(settings.showCenterTop) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center center no-repeat; '+ showOption(settings.showCenter) +'"></div>' +

							'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageCenter +') center bottom no-repeat; '+ showOption(settings.showCenterBottom) +'"></div>';



						if(settings.horizontal === true){

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left bottom no-repeat; '+ showOption(settings.showFloatLeftBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') left center no-repeat; '+ showOption(settings.showFloatLeftCenter) +'"></div>' +						

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>' +

								'<div class="splitscreen-logo-right splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>';							

							} else{

							$.splitscreenHtml = $.splitscreenHtml +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right top no-repeat; '+ showOption(settings.showFloatRightTop) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right center no-repeat; '+ showOption(settings.showFloatRightCenter) +'"></div>' +

								'<div class="splitscreen-logo" style="background:transparent url('+ settings.imageDir + settings.imageFloating +') right bottom no-repeat; '+ showOption(settings.showFloatRightBottom) +'"></div>';

								}



						$.splitscreenHtml = $.splitscreenHtml +	

						'</div>' +

						'<div class="splitscreen-shadow-left splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +		

						'</div>' +

						'<div class="splitscreen-shadow-right splitscreen-erase">' +

							'<div class="splitscreen-shadow splitscreen-erase"></div>' +							

						'</div>' +												

						'<!--[ UNDERLAY ]-->' +

						'<div class="splitscreen-underlay splitscreen-erase-fade" style="background:'+ settings.colorUnderlay +'; filter:alpha(opacity='+ settings.alphaUnderlay +'); -moz-opacity:0.'+ settings.alphaUnderlay +'; opacity:0.'+ settings.alphaUnderlay +'; filter:progid:DXImageTransform.Microsoft.Alpha(opacity='+ settings.alphaUnderlay +'); '+ showOption(settings.showUnderlay) +';"></div>' +		

						'<div class="splitscreen-teaser">' +

							'<table class="splitscreen-teaser-holder" cellpadding="0" cellspacing="0"><tbody><td class="splitscreen-teaser-body" valign="'+ settings.verticalAlignTeaser +'" align="left"></td></tbody></table>' +						

						'</div>' +

					'</div>' +

				'</div>' +

				'<!--[ STOP SPLITSCREEN ]-->';

				}			

			

			/*--------------------------------*/

			/* SPLITSCREEN APPLY SPLITSCREEN  */

			/*--------------------------------*/			

		

			// Prepend Splitscreen to element	

			$('#'+$(target).attr('id')+'').prepend($.splitscreenHtml);

			

			// Hide body scrollbar while a fullscreen Splitscreen is active

			$('#'+$(target).attr('id')+'').addClass("splitscreen-body");



			// Add teaser Html to the teaser section

			$('#'+$(target).attr('id')+' div.splitscreen-teaser td.splitscreen-teaser-body').append($('div#'+$(target).attr('id')+'-html'));



			/*---------------------------------------*/

			/* SPLITSCREEN RESIZE + CENTER ACTIVATE */

			/*---------------------------------------*/



			$.splitscreenCenterDiv = function(theItem) {

				var divWidth=$('#'+$(target).attr('id')).width();

				var divHeight=$('#'+$(target).attr('id')).height();

				var divCenter=divWidth/2;

				var itemCenter=$(theItem).width()/2;

				var theCenter=divCenter-itemCenter;

				var divMiddle=divHeight/2;

				var itemMiddle=$(theItem).height()/2;

				var theMiddle=divMiddle-itemMiddle;

				if(divWidth>$(theItem).width()){ //horizontal

					$(theItem).css('left',theCenter);

					} else {

						$(theItem).css('left','0');

						}

				if(divHeight>$(theItem).height()){ //vertical

					$(theItem).css('top',theMiddle);

					} else {

						$(theItem).css('top','0');

						}

					};



			$.splitscreenCenterWin = function(theItem) {

				var winWidth=$(window).width();

				var winHeight=$(window).height();

				var windowCenter=winWidth/2;

				var itemCenter=$(theItem).width()/2;

				var theCenter=windowCenter-itemCenter;

				var windowMiddle=winHeight/2;

				var itemMiddle=$(theItem).height()/2;

				var theMiddle=windowMiddle-itemMiddle;

				if(winWidth>$(theItem).width()){ //horizontal

					$(theItem).css('left',theCenter);

					} else {

						$(theItem).css('left','0');

						}

				if(winHeight>$(theItem).height()){ //vertical

					$(theItem).css('top',theMiddle);

					} else {

						$(theItem).css('top','0');

						}

					};	

			

			if(settings.fullscreen === true){			

				$('body').addClass("splitscreen-body");				

				$('#'+$(target).attr('id')+'').addClass("fullscreen-splitscreen");

				$('#'+$(target).attr('id')+' .splitscreen, #'+$(target).attr('id')+' .splitscreen-main, #'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-left, #'+$(target).attr('id')+' .splitscreen-shadow-right, #'+$(target).attr('id')+' .splitscreen-activate, #'+$(target).attr('id')+' .splitscreen-activate-2, #'+$(target).attr('id')+' .splitscreen-underlay, #'+$(target).attr('id')+' .splitscreen-teaser, #'+$(target).attr('id')+' .splitscreen-button-div, #'+$(target).attr('id')+' .splitscreen-load-mask').css({'position' : 'fixed'});



				$.splitscreenFullScreenBackground = function(theItem) {

				

					var winWidth=$(window).width();

					var winHeight=$(window).height();

					var imageWidth=$(theItem).width();

					var imageHeight=$(theItem).height();

				

					var picHeight = imageHeight / imageWidth;

					var picWidth = imageWidth / imageHeight;

					

					if ((winHeight / winWidth) < picHeight) {

						$(theItem).css("width",winWidth);

						$(theItem).css("height",picHeight*winWidth);

						$(theItem).css("left",0);

						} else {

							$(theItem).css("height",winHeight);

							$(theItem).css("width",picWidth*winHeight);							

							m = winWidth;

							o = picWidth*winHeight;

							if(m < o){

							$(theItem).css("left",(m - o)/2);

							}else{

						$(theItem).css("left",0);							

							}

							}

					$(theItem).css("margin-left",((winWidth / $(theItem).width()) / 2) -0.05);

					$(theItem).css("margin-top",((winHeight / $(theItem).height()) / 2) -0.05);	



					};

				

				$(document).ready(function() {

					$.splitscreenFullScreenBackground('#'+$(target).attr('id')+' .splitscreen-fullscreen');					

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-activate');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-activate-2');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-teaser');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-button-div');					

					});

					

				$(window).resize(function() {

					$.splitscreenFullScreenBackground('#'+$(target).attr('id')+' .splitscreen-fullscreen'); 

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-activate');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-activate-2');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-teaser');

					$.splitscreenCenterWin('#'+$(target).attr('id')+' .splitscreen-button-div');					

					});

					}else{				

						$('#'+$(target).attr('id')+' .splitscreen, #'+$(target).attr('id')+' .splitscreen-main, #'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-left, #'+$(target).attr('id')+' .splitscreen-shadow-right, #'+$(target).attr('id')+' .splitscreen-activate, #'+$(target).attr('id')+' .splitscreen-activate-2, #'+$(target).attr('id')+' .splitscreen-underlay, #'+$(target).attr('id')+' .splitscreen-teaser, #'+$(target).attr('id')+' .splitscreen-button-div, #'+$(target).attr('id')+' .splitscreen-load-mask').css({'position' : 'absolute'});

						$('#'+$(target).attr('id')+' .splitscreen').css({'z-index': 299});

				

						$.splitscreenFullDivBackground = function(theItem,target) {

				

							var winWidth=$(target).width();

							var winHeight=$(target).height();

							var imageWidth=$(theItem).width();

							var imageHeight=$(theItem).height();

				

							var picHeight = imageHeight / imageWidth;

							var picWidth = imageWidth / imageHeight;

				

							if ((winHeight / winWidth) < picHeight) {

								$(theItem).css("width",winWidth);

								$(theItem).css("height",picHeight*winWidth);

								} else {

									$(theItem).css("height",winHeight);

									$(theItem).css("width",picWidth*winHeight);

									}

							$(theItem).css("margin-left",winWidth / $(theItem).width() / 2);

							$(theItem).css("margin-top",winHeight / $(theItem).height() / 2);

							};					



						$(document).ready(function() {

							$('#'+$(target).attr('id')+' .splitscreen-load-mask').css({'z-index':'998'});

							$.splitscreenFullDivBackground('#'+$(target).attr('id')+' .splitscreen-fullscreen', $(target));

							});



						$(target).resize(function() {

							$.splitscreenFullDivBackground('#'+$(target).attr('id')+' .splitscreen-fullscreen'); 

							$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-activate');

							$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-activate-2');

							$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-teaser');

							$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-button-div');					

							});			

						}

					

			/*-------------------------------*/

			/* SPLITSCREEN ANIMATION SECTION */

			/*-------------------------------*/

			

			// Animation vars			

			$.split = {alreadyopen: {}, intro: {}, auto: {}, dismiss: {}, postfade: {}};

			$.splitpercent = settings.splitPercent.replace("%", "");	

			$.negPull = '-'+ (parseFloat($.splitpercent)/2)+'%';

			$.posPull = 50 + (parseFloat($.splitpercent)/2)+'%';

			$.marginPull = '-'+((parseFloat($.splitpercent)/2))+'%';

			$.fadePull = (100 - (parseFloat($.splitpercent)))/2+'%';

			$.bodySize = parseFloat($.splitpercent)+'%';

			

			$.split.alreadyopen[''+$(target).attr('id')+''] = false;

			

			if (settings.splitMode == 'splash'){

					$.cssPull = parseFloat($.splitpercent)+'%';

				}else{

					if(parseFloat($.splitpercent) < 37){

						$.cssPull = parseFloat($.splitpercent)+'%';

						}else{

							$.cssPull = 37+'%';

							}

					}			

			if (settings.showShadow == true){

					$.showShadow = 'block';

				}else{

					$.showShadow = 'none';

					}			

			if (settings.showFade == true){

					$.showFade = 'block';

				}else{

					$.showFade = 'none';

					}

					

			// Horizontal + Vertical Switching	

			if (settings.horizontal === true){

				var splitway = {

					resetCss : {'width' : '100%', 'height' : ''+$.cssPull+''},

					resetTease : {'width' : '100%', 'height' : ''+$.bodySize+''},				

					resetFade : {'height' : ''+$.fadePull+''},

					resetFadeShow : ''+$.showFade+'',

					resetShadowShow : ''+$.showShadow+'',

					resetAutoL : {'top' : '-15%'},

					resetAutoR : {'top' : '65%'},

					resetL : {'top' : '0%'},

					resetR : {'top' : '50%'},

					animiL : {'top' : ''+$.negPull+'' },

					animiR : {'top' : ''+$.posPull+'' },

					resetAct : {'height' : ''+$.cssPull+''},

					animiAct : {'height' : '0px'},

					resetAct2 : {'height' : ''+$.cssPull+''},

					closeL : {'top' : '-150%'},

					closeR : {'top' : '200%'}

					};

					

				$('#'+$(target).attr('id')+' .splitscreen-logo-left').css({ 'top' : '0', 'height' : '200%'});

				$('#'+$(target).attr('id')+' .splitscreen-logo-right').css({ 'top' : '-100%', 'height' : '200%'});



				$('#'+$(target).attr('id')+' .splitscreen-left').css({ 'top' : '0', 'left' : '0', 'width' : '100%', 'height' : '50%'});

				$('#'+$(target).attr('id')+' .splitscreen-right').css({ 'top' : '50%', 'left' : '0', 'width' : '100%', 'height' : '50%'});



				$('#'+$(target).attr('id')+' .splitscreen-bg-left').css({ 'top' : '0', 'left' : '0'});

				$('#'+$(target).attr('id')+' .splitscreen-bg-right').css({ 'bottom' : '100%', 'left' : '0'});



				$('#'+$(target).attr('id')+' .splitscreen-shadow-left').css({ 'top' : '0', 'left' : '0', 'margin-top' : '10px', 'height' : '50%', 'width' : '100%', 'display' : ''+splitway.resetShadowShow+''});

				$('#'+$(target).attr('id')+' .splitscreen-shadow-right').css({ 'top' : '0', 'top' : '50%', 'margin-top' : '-10px', 'height' : '50%', 'width' : '100%', 'display' : ''+splitway.resetShadowShow+''});



				$('#'+$(target).attr('id')+' .splitscreen-shadow-left .splitscreen-shadow').css({ 'top' : '0', 'left' : '0', 'width' : '100%', 'height' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+settings.imageDir+'shadow-top.png")', 'backgroundPosition' : 'bottom left', 'backgroundRepeat' : 'repeat-x'});

				$('#'+$(target).attr('id')+' .splitscreen-shadow-right .splitscreen-shadow').css({ 'top' : '0', 'right' : '0', 'width' : '100%', 'height' : '100%', 'background-color' : 'transparent', 'backgroundImage' : 'url("'+settings.imageDir+'shadow-bottom.png")', 'backgroundPosition' : 'top left', 'backgroundRepeat' : 'repeat-x'});



				$('#'+$(target).attr('id')+' .splitscreen-fade-left').css({ 'top' : '0%', 'left' : '0', 'width' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+ settings.imageDir + settings.imageFadeTop +'")', 'backgroundPosition' : '0 0', 'backgroundRepeat' : 'repeat-x', 'backgroundSize' : '3%', 'display' : ''+splitway.resetFadeShow+''});

				$('#'+$(target).attr('id')+' .splitscreen-fade-right').css({ 'bottom' : '0%', 'left' : '0', 'width' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+ settings.imageDir + settings.imageFadeBottom +'")', 'backgroundPosition' : '0 100%', 'backgroundRepeat' : 'repeat-x', 'backgroundSize' : '3%', 'display' : ''+splitway.resetFadeShow+''});

					

				}



			if (settings.horizontal === false){

				var splitway = {

					resetCss : {'height' : '100%', 'width' : ''+$.cssPull+''},

					resetTease : {'height' : '100%', 'width' : ''+$.bodySize+''},

					resetFade : {'width' : ''+$.fadePull+''},

					resetFadeShow : ''+$.showFade+'',

					resetShadowShow : ''+$.showShadow+'',

					resetAutoL : {'left' : '-15%'},

					resetAutoR : {'left' : '65%'},

					resetL : {'left' : '0%'},

					resetR : {'left' : '50%'},

					animiL : {'left' : ''+$.negPull+'' },

					animiR : {'left' : ''+$.posPull+'' },

					resetAct : {'width' : ''+$.cssPull+''},

					animiAct : {'width' : '0px'},

					resetAct2 : {'width' : ''+$.cssPull+''},

					closeL : {'left' : '-150%'},

					closeR : {'left' : '200%'}

					};

					

					$('#'+$(target).attr('id')+' .splitscreen-logo-left').css({ 'left' : '0', 'width' : '200%'});

					$('#'+$(target).attr('id')+' .splitscreen-logo-right').css({ 'right' : '0', 'width' : '200%'});



					$('#'+$(target).attr('id')+' .splitscreen-left').css({ 'top' : '0', 'left' : '0', 'width' : '50%', 'height' : '100%'});

					$('#'+$(target).attr('id')+' .splitscreen-right').css({ 'top' : '0', 'left' : '50%', 'width' : '50%', 'height' : '100%'});



					$('#'+$(target).attr('id')+' .splitscreen-bg-left').css({ 'top' : '0', 'left' : '0'});

					$('#'+$(target).attr('id')+' .splitscreen-bg-right').css({ 'right' : '100%', 'top' : '0'});



					$('#'+$(target).attr('id')+' .splitscreen-shadow-left').css({ 'top' : '0', 'left' : '0', 'margin-left' : '10px', 'width' : '50%', 'height' : '100%', 'display' : ''+splitway.resetShadowShow+''});

					$('#'+$(target).attr('id')+' .splitscreen-shadow-right').css({ 'top' : '0', 'left' : '50%', 'margin-left' : '-10px', 'width' : '50%', 'height' : '100%', 'display' : ''+splitway.resetShadowShow+''});



					$('#'+$(target).attr('id')+' .splitscreen-shadow-left .splitscreen-shadow').css({ 'top' : '0', 'left' : '0', 'width' : '100%', 'height' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+settings.imageDir+'shadow-left.png")', 'backgroundPosition' : 'top right', 'backgroundRepeat' : 'repeat-y'});

					$('#'+$(target).attr('id')+' .splitscreen-shadow-right .splitscreen-shadow').css({ 'top' : '0', 'right' : '0', 'width' : '100%', 'height' : '100%', 'background-color' : 'transparent', 'backgroundImage' : 'url("'+settings.imageDir+'shadow-right.png")', 'backgroundPosition' : 'top left', 'backgroundRepeat' : 'repeat-y'});



					$('#'+$(target).attr('id')+' .splitscreen-fade-left').css({ 'left' : '0', 'height' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+ settings.imageDir + settings.imageFadeLeft +'")', 'backgroundPosition' : '0 0', 'backgroundRepeat' : 'repeat-y', 'backgroundSize' : '50%', 'display' : ''+splitway.resetFadeShow+''});

					$('#'+$(target).attr('id')+' .splitscreen-fade-right').css({ 'right' : '0', 'height' : '100%', 'backgroundColor' : 'transparent', 'backgroundImage' : 'url("'+ settings.imageDir + settings.imageFadeRight +'")', 'backgroundPosition' : '0 0', 'backgroundRepeat' : 'repeat-y', 'backgroundSize' : '100%', 'display' : ''+splitway.resetFadeShow+''});				

					}

				

			$('#'+$(target).attr('id')+' .splitscreen-activate, #'+$(target).attr('id')+' .splitscreen-activate-2').css(splitway.resetCss);

			$('#'+$(target).attr('id')+' .splitscreen-teaser, #'+$(target).attr('id')+' .splitscreen-button-div').css(splitway.resetTease);

			$('#'+$(target).attr('id')+' .splitscreen-fade-left, #'+$(target).attr('id')+' .splitscreen-fade-right').css(splitway.resetFade);

			

			// Automation sequences				

			$.splitscreenUpdate = function(target,resetAutoL,resetAutoR,resetL,resetR) {

				if ($.split.alreadyopen[''+$(target).attr('id')+''] === false){

					$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(resetAutoL, {duration: 1000, easing: 'jswing'});

					$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(resetAutoR, {duration: 1000, easing: 'jswing'});

					$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(resetL, {duration: 1000, easing: 'jswing'});

					$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(resetR, {duration: 1000, easing: 'jswing'});		

					}				

				};				



			if(settings.showIntroSplit === true){

				$.split.intro[''+$(target).attr('id')+''] = setTimeout(function() { $.splitscreenUpdate(target,splitway.resetAutoL,splitway.resetAutoR,splitway.resetL,splitway.resetR); }, settings.splitTimeIntro);			

				}			

			if(settings.showAutoSplit === true){

				$.split.auto[''+$(target).attr('id')+''] = setInterval(function() { $.splitscreenUpdate(target,splitway.resetAutoL,splitway.resetAutoR,splitway.resetL,splitway.resetR); }, settings.splitTimeAuto);	

				}

			if(settings.showDismissSplit === true){

				$.split.dismiss[''+$(target).attr('id')+''] = setTimeout(function() { $.destroySplitscreen(target,splitway.closeL,splitway.closeR); }, settings.splitTimeDismiss);	

				}

				

			// if Mobile + Tablet

			if (DetectTierIphone() || DetectTierTablet() || settings.onlyClick === true){



				if(settings.splitMode == 'splash'){			

					$('#'+$(target).attr('id')+' .splitscreen-activate').mousedown(function () { 

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

						$.split.alreadyopen[''+$(target).attr('id')+''] = true;

						});					

					$('#'+$(target).attr('id')+' .splitscreen-sector').mousedown(function () { 

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetR, {duration: 1000, easing: 'jswing'});

						$.split.alreadyopen[''+$(target).attr('id')+''] = false;

						});						

					}

			

				if(settings.splitMode == 'promo' || settings.splitMode == 'teaser'){			

					$('#'+$(target).attr('id')+' .splitscreen-activate').mousedown(function () { 

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);						

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});					

						$('#'+$(target).attr('id')+' .splitscreen-activate').animate(splitway.animiAct, {duration: 800, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-activate').queue(function() {

							$('#'+$(target).attr('id')+' .splitscreen-activate-2').css({'display' : 'none'});							

							$(this).dequeue();								

							});	

						$.split.alreadyopen[''+$(target).attr('id')+''] = true;

						});	

						

					$('#'+$(target).attr('id')+' .splitscreen-underlay').mousedown(function () { 		

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

						$.split.alreadyopen[''+$(target).attr('id')+''] = true;

						});

						

					$('#'+$(target).attr('id')+' .splitscreen-teaser').mousedown(function () { 			

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

						$.split.alreadyopen[''+$(target).attr('id')+''] = true;

						});

						

					$('#'+$(target).attr('id')+' .splitscreen-sector').mousedown(function () { 

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-activate').queue('fx', []);

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetL, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetR, {duration: 1000, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-activate').animate(splitway.resetAct, {duration: 800, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-activate-2').css({'display' : 'block'});

						$.split.alreadyopen[''+$(target).attr('id')+''] = false;

						});

					}

				// else Desktop + Laptop	

				}else{

                   

					if(settings.splitMode == 'splash'){			

						$('#'+$(target).attr('id')+' .splitscreen-activate').mouseenter(function () { 

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

							$.split.alreadyopen[''+$(target).attr('id')+''] = true;

							});					

						$('#'+$(target).attr('id')+' .splitscreen-sector').mouseenter(function () { 

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetR, {duration: 1000, easing: 'jswing'});

							$.split.alreadyopen[''+$(target).attr('id')+''] = false;

							});						

						}

			

					if(settings.splitMode == 'promo' || settings.splitMode == 'teaser'){			

						$('#'+$(target).attr('id')+' .splitscreen-activate').mouseenter(function () { 

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);						

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});					

							$('#'+$(target).attr('id')+' .splitscreen-activate').animate(splitway.animiAct, {duration: 800, easing: 'jswing'});						

							$('#'+$(target).attr('id')+' .splitscreen-activate').queue(function() {

								$('#'+$(target).attr('id')+' .splitscreen-activate-2').css({'display' : 'none'});							

								$(this).dequeue();								

								});

							$.split.alreadyopen[''+$(target).attr('id')+''] = true;

							});

							

						$('#'+$(target).attr('id')+' .splitscreen-underlay').mouseenter(function () { 		

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

							$.split.alreadyopen[''+$(target).attr('id')+''] = true;

							});				

						

						$('#'+$(target).attr('id')+' .splitscreen-teaser').mouseenter(function () { 			

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.animiL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.animiR, {duration: 1000, easing: 'jswing'});

							$.split.alreadyopen[''+$(target).attr('id')+''] = true;

							});	

						

						$('#'+$(target).attr('id')+' .splitscreen-sector').mouseenter(function () { 

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-activate').queue('fx', []);

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetL, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetR, {duration: 1000, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-activate').animate(splitway.resetAct, {duration: 800, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-activate-2').css({'display' : 'block'});	

							$.split.alreadyopen[''+$(target).attr('id')+''] = false;

							});

						}

					}



			/*-------------------------------*/

			/* SPLITSCREEN CONTROLS          */

			/*-------------------------------*/

					

				// Open Splitscreen by function

				$.openSplitscreen = function(target) {

					$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetAutoL, {duration: 1000, easing: 'jswing'});

					$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetAutoR, {duration: 1000, easing: 'jswing'});

					$.split.alreadyopen[''+$(target).attr('id')+''] = true;				

					};

					

				// Open Splitscreen by link

				$.splitscreenOpener = function(target) {				

					$('#'+$(target).attr('id')+' .o-splitscreen').live('click', function() {

						$.openSplitscreen(target);

						});					

					};						

				

				// Close Splitscreen by function

				$.closeSplitscreen = function(target) {

					$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.resetL, {duration: 1000, easing: 'jswing'});

					$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.resetR, {duration: 1000, easing: 'jswing'});		

					$.split.alreadyopen[''+$(target).attr('id')+''] = false;				

					};



				// Close Splitscreen by link

				$.splitscreenCloser = function(target) {				

					$('#'+$(target).attr('id')+' .c-splitscreen').live('click', function() {

						$.closeSplitscreen(target);

						});					

					};						

					

				// Destroy Splitscreen by function

				$.destroySplitscreen = function(target,closeL,closeR) {

					if (closeL === undefined){

						$('#'+$(target).attr('id')+' .splitscreen-underlay, #'+$(target).attr('id')+' .splitscreen-fade-left, #'+$(target).attr('id')+' .splitscreen-fade-right').fadeOut({duration: settings.splitDismissDuration + 1000});

						$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(splitway.closeL, {duration: settings.splitDismissDuration, easing: 'jswing'});

						$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(splitway.closeR, {duration: settings.splitDismissDuration, easing: 'jswing'}).queue(function() {

							$('#'+$(target).attr('id')+'').css({'display':'none'});							

							$('#'+$(target).attr('id')+'').removeClass("fullscreen-splitscreen");												

							if($('.fullscreen-splitscreen').length == 0){

								$('body').removeClass("splitscreen-body");

								}						

						$(this).dequeue();

								});

						}else{

							$('#'+$(target).attr('id')+' .splitscreen-underlay, #'+$(target).attr('id')+' .splitscreen-fade-left, #'+$(target).attr('id')+' .splitscreen-fade-right').fadeOut({duration: settings.splitDismissDuration + 1000});

							$('#'+$(target).attr('id')+' .splitscreen-left, #'+$(target).attr('id')+' .splitscreen-shadow-left').animate(closeL, {duration: settings.splitDismissDuration, easing: 'jswing'});

							$('#'+$(target).attr('id')+' .splitscreen-right, #'+$(target).attr('id')+' .splitscreen-shadow-right').animate(closeR, {duration: settings.splitDismissDuration, easing: 'jswing'}).queue(function() {

							$('#'+$(target).attr('id')+'').css({'display':'none'});							

							$('#'+$(target).attr('id')+'').removeClass("fullscreen-splitscreen");												

							if($('.fullscreen-splitscreen').length == 0){

								$('body').removeClass("splitscreen-body");

								}						

						$(this).dequeue();

								});

							}						



					if(settings.autoSplit === true){clearInterval($.split.auto[''+$(target).attr('id')+'']);}

					};				

				

				// Destroy Splitscreen by link

				$.splitscreenDestroyer = function(target,closeL,closeR) {				

					$('#'+$(target).attr('id')+' .x-splitscreen').live('click', function() {

						$.destroySplitscreen(target,closeL,closeR);

						if(settings.autoSplit === true){clearInterval($.split.auto[''+$(target).attr('id')+'']);}

						});					

					};



			/*-------------------------------------*/

			/* SPLITSCREEN RUN WHEN INITIALIZED    */

			/*-------------------------------------*/

			

				// Hotlinking

				$.splitscreenOpener($(target));	

				$.splitscreenCloser($(target));	

				$.splitscreenDestroyer($(target),splitway.closeL,splitway.closeR);						

					

				// Centering

				$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-activate');

				$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-activate-2');

				$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-teaser');

				$.splitscreenCenterDiv('#'+$(target).attr('id')+' .splitscreen-button-div');

				

				// No Clicking

				if(settings.noClick === true){

				$('#'+$(target).attr('id')+' .splitscreen-activate, #'+$(target).attr('id')+' .splitscreen-activate-2').css({'display':'none'});				

				}				



				// Preloading

				$(window).load(function() {

					$('#'+$(target).attr('id')+' .splitscreen-load-mask').css({'display':'none'});

					});					

				

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

			}else{} //CLOSE OF COOKIE CHECK

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/	

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/ 

		/*--------------------------------------------------------------*/

		/*--------------------------------------------------------------*/

		};		

	})(jQuery);