<?php

App::uses('AppModel', 'Model');
App::uses('AuthComponent', 'Controller/Component');
/**
 * User Model
 *
 */
class User extends AppModel {

public function beforeSave($options = array()) {
    if (isset($this->data[$this->alias]['password'])) {
        $this->data[$this->alias]['password'] = AuthComponent::password($this->data[$this->alias]['password']);
    }
    return true;
}
/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		 'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter name.',
			),
		),
		'email' => array(
			'email' => array(
			    'rule' => 'email',
			    'message' => 'Please enter valid email address.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checkemail',
					'email'
			     ) ,
			     'message' => 'Email address is already in use.',
			),
		),
		'username' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter username.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checkusername',
					'username'
			     ) ,
			     'message' => 'username is already in use.',
			),
		),
		
	);
	
	function _checkemail($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['User.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['User.email'] =  $this->data[$this->name][$field2];
		$user_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($user_count>0)
			return false;
		return true;
	}
	function _checkusername($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['User.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['User.username'] =  $this->data[$this->name][$field2];
		$user_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($user_count>0)
			return false;
		return true;
	}
}
