<?php
App::uses('AppModel', 'Model');
class Seller extends AppModel {
	var $name = 'User';
	
	public $hasOne = array(
		'SellerBankDetail' => array(
			'className' => 'SellerBankDetail',
			'foreignKey' => 'user_id',
			'dependent' => true,
		),
		'SellerCompanyInformation' => array(
			'className' => 'SellerCompanyInformation',
			'foreignKey' => 'user_id',
			'dependent' => true,
		),
	);
	
	public $hasMany = array(
		'SellerOpeningTime' => array(
			'className' => 'SellerOpeningTime',
			'foreignKey' => 'user_id',
			'dependent' => true,
		),
		'SellerPaymentMethod' => array(
			'className' => 'SellerPaymentMethod',
			'foreignKey' => 'user_id',
			'dependent' => true,
		),
		'SellerSellingPoint' => array(
			'className' => 'SellerSellingPoint',
			'foreignKey' => 'user_id',
			'dependent' => true,
		),
	);
	public function beforeSave($options = array()) {
    if (isset($this->data[$this->alias]['password'])) {
        $this->data[$this->alias]['password'] = AuthComponent::password($this->data[$this->alias]['password']);
    }
    return true;
}
/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		 'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter name.',
			),
		),
		'email' => array(
			'email' => array(
			    'rule' => 'email',
			    'message' => 'Please enter valid email address.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checkemail',
					'email'
			     ) ,
			     'message' => 'Email address is already in use.',
			),
		),
		
	);
	
	function _checkemail($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['Seller.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['Seller.email'] =  $this->data['Seller'][$field2];
		$user_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($user_count>0)
			return false;
		return true;
	}
}
