<?php
App::uses('AppController', 'Controller');
class WritingPricesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('WritingPrice','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'WritingPrice.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->WritingPrice->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->WritingPrice->updateAll(array("WritingPrice.status"=>'0'),array("WritingPrice.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->WritingPrice->updateAll(array("WritingPrice.status"=>'1'),array("WritingPrice.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->WritingPrice->updateAll(array("WritingPrice.show_home"=>'1'),array("WritingPrice.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->WritingPrice->updateAll(array("WritingPrice.show_home"=>'0'),array("WritingPrice.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->WritingPrice->deleteAll(array('WritingPrice.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['WritingPrice']['title']) && $this->data['WritingPrice']['title']!='') $title = $this->data['WritingPrice']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['WritingPrice']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['WritingPrice.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('WritingPrice.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('writing_prices', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add WritingPrice'));
		if ($this->request->is('post')) {
			$this->WritingPrice->create();	
			$pre_title_check = $this->WritingPrice->find("count",array("conditions"=>array("WritingPrice.title"=>$this->request->data['WritingPrice']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['WritingPrice']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->WritingPrice->save($this->request->data['WritingPrice'])){
					$this->Session->setFlash(__('Writing Price has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Writing Price could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Writing Price title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit WritingPrice'));
		$this->WritingPrice->id = $id;
		$selected = "";
		
		$driver_detail = $this->WritingPrice->find("first",array("conditions"=>array("WritingPrice.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->WritingPrice->exists()) {
			throw new NotFoundException(__('Invalid writing_price'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['WritingPrice']['id']=$id;		
			$pre_title_check = $this->WritingPrice->find("count",array("conditions"=>array("WritingPrice.title"=>$this->request->data['WritingPrice']['title'],"WritingPrice.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->WritingPrice->saveAll($this->request->data['WritingPrice'])) {
					$this->Session->setFlash(__('Writing Price has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Writing Price could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Writing Price title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->WritingPrice->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->WritingPrice->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->WritingPrice->id = $id;
		if (!$this->WritingPrice->exists()) {
			throw new NotFoundException(__('Invalid Writing Price'));
		}
		else
		{
			if ($this->WritingPrice->delete()) {
				$this->Session->setFlash(__('Writing Price has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Writing Price could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
