<?php
App::uses('AppController', 'Controller');
class UserLoginsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('UserLogin','EmailTemplate','ApplicationSetting','FamilyMember'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'UserLogin.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	
	public function admin_index($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->UserLogin->recursive = 0;
		if(isset($this->data['UserLogin']['fromdate']) && $this->data['UserLogin']['fromdate']!='') $fromdate = $this->data['UserLogin']['fromdate'];	
		else if(isset($this->params['named']['fromdate']) && $this->params['named']['fromdate']!='') $fromdate = $this->request->data['UserLogin']['fromdate']=$this->params['named']['fromdate'];
		
		if(isset($this->data['UserLogin']['todate']) && $this->data['UserLogin']['todate']!='') $todate = $this->data['UserLogin']['todate'];	
		else if(isset($this->params['named']['todate']) && $this->params['named']['todate']!='') $todate = $this->request->data['UserLogin']['todate']=$this->params['named']['todate'];
		
		$conditions = array("user_id"=>$id); 
		$pagingArgs = array(); 
		
		if(!empty($fromdate))
		{
			$conditions['UserLogin.login_time >= ']=$fromdate;
			$pagingArgs['fromdate'] = $fromdate;
		}
		if(!empty($todate))
		{
			$conditions['UserLogin.login_time <='] = $todate;
			$pagingArgs['todate'] = $todate;
		}
		
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('UserLogin.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('user_logins', $rows);
		$this->set('id', $id);
		
		$this->params['page_title'] = "UserLogin";
		if($id != null){
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='Delete')
				$this->UserLogin->deleteAll(array('UserLogin.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		$this->request->data = $this->UserLogin->read(null, $id);
		}
	}
	public function admin_delete($staff_id=NULL,$id = null) {
		$this->checkAdmin();
		$this->UserLogin->id = $id;
		if (!$this->UserLogin->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		else
		{
			if ($this->UserLogin->delete()) {
				$this->Session->setFlash(__('User Login has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index',$staff_id));
			}
		}
		$this->Session->setFlash(__('User Login could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index',$staff_id));
	}
}
