<?php
App::uses('AppController', 'Controller');
class PagesController extends AppController {
	public $name = 'Pages';
	
	public $helpers = array('Html', 'Session','Fck','Text', 'Js','Common','thumbnail');
	public $uses = array('Page','Category'); 
	public function admin_dashboard()
	{
		$this->layout = 'admin_full';
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Dashboard'));
		$this->params['page_title'] = "Dashboard";
	}
	public function admin_index(){
		$this->checkAdmin();
		$this->set('title_for_layout', __('Pages'));
		//$this->Html->addCrumb('Site Pages', '/pages');
		if(isset($this->data['Page']['name']) && $this->data['Page']['name']!='') $name = $this->data['Page']['name'];	
		else if(isset($this->params['named']['name']) && $this->params['named']['name']!='') $name = $this->request->data['Page']['name']=$this->params['named']['name'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($name))
		{
			//$conditions['Page.name LIKE '] = '%'.$name.'%';
			$conditions[]="((Page.name LIKE '%$name%') or (Page.content LIKE '%$name%'))";
			$pagingArgs['name'] = $name;
		}
		$this->set("pagingArgs",$pagingArgs);
		$rows  = $this->paginate('Page',$conditions);
		$this->set('pages', $rows);
	}
	
	public function admin_add() {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Pages : Add'));
		if ($this->request->is('post')) {
			$this->Page->create();
			if ($this->Page->save($this->request->data)) {
				$this->Session->setFlash(__('The Page has been saved'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Page could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}
		}
	}
	
	public function admin_edit($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Pages : Edit'));
		if (!empty($this->request->data)) {
			$this->request->data['Page']['id'] = $id;
			if ($this->Page->save($this->request->data)) {
				$this->Session->setFlash(__('The Page has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				$errors = $this->Page->validationErrors;
				$arr=array();
				if(!empty($errors))
				{
					foreach($errors as $error)
					{
						$arr[]=$error[0];
					}
					$msg=implode('\n',$error);
				}
				else
					$msg='';
				$this->Session->setFlash(__($msg), 'default', array('class' => 'error'));
			}
		}else {
			$this->request->data = $this->Page->read(null, $id);
		}
	}
	
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->Page->id = $id;
		if (!$this->Page->exists()) {
			throw new NotFoundException(__('Invalid Page'));
		}
		
		if ($this->Page->delete()) {
			$this->Session->setFlash(__('The Page has been deleted successfully.'), 'default', array('class' => 'success'));
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(__('The Page could not be delete. Please, try again.'), 'default', array('class' => 'error'));
		$this->redirect(array('action' => 'index'));
	}
	public function view()
	{
		$this->layout='home';
	}
	public function about()
	{
	}
	public function how_it_works()
	{
	}
	public function terms()
	{
	}
	public function privacy()
	{
	}
	public function privacy_policy()
	{
	}
	public function return_policy()
	{
	}
	public function payment_policy()
	{
	}
	public function terms_of_use()
	{
	}
	public function thanks()
	{
	}
	public function site_page($alias = NULL)
	{
		$this->set('title_for_layout', __($alias));
		$this->loadModel('Page');
		$this->set('page',$this->Page->find('first',array('conditions'=>array('Page.h1tag'=>$alias))));
	}
	public function dashboard()
	{
		
	}
	public function index()
	{
		$slug=$this->request->params['slug'];
		$detail=$this->Page->find("first",array("conditions"=>array("Page.page_permalink"=>$slug)));
		$this->set("detail",$detail['Page']);
	}
}