<?php
App::uses('AppController', 'Controller');
class OperatorTypesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('OperatorType','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'OperatorType.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->OperatorType->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->OperatorType->updateAll(array("OperatorType.status"=>'0'),array("OperatorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->OperatorType->updateAll(array("OperatorType.status"=>'1'),array("OperatorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->OperatorType->updateAll(array("OperatorType.show_home"=>'1'),array("OperatorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->OperatorType->updateAll(array("OperatorType.show_home"=>'0'),array("OperatorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->OperatorType->deleteAll(array('OperatorType.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['OperatorType']['title']) && $this->data['OperatorType']['title']!='') $title = $this->data['OperatorType']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['OperatorType']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['OperatorType.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('OperatorType.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('operator_types', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add OperatorType'));
		if ($this->request->is('post')) {
			$this->OperatorType->create();	
			$pre_title_check = $this->OperatorType->find("count",array("conditions"=>array("OperatorType.title"=>$this->request->data['OperatorType']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['OperatorType']['date_time']			=	date("Y-m-d H:i:s");
				$this->request->data['OperatorType']['status']				=	1;
				if ($res=$this->OperatorType->save($this->request->data['OperatorType'])){
					$this->Session->setFlash(__('Operator Type has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Operator Type could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Operator Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit OperatorType'));
		$this->OperatorType->id = $id;
		$selected = "";
		
		$driver_detail = $this->OperatorType->find("first",array("conditions"=>array("OperatorType.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->OperatorType->exists()) {
			throw new NotFoundException(__('Invalid operator_type'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['OperatorType']['id']=$id;		
			$pre_title_check = $this->OperatorType->find("count",array("conditions"=>array("OperatorType.title"=>$this->request->data['OperatorType']['title'],"OperatorType.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->OperatorType->saveAll($this->request->data['OperatorType'])) {
					$this->Session->setFlash(__('Operator Type has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Operator Type could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Operator Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->OperatorType->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->OperatorType->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->OperatorType->id = $id;
		if (!$this->OperatorType->exists()) {
			throw new NotFoundException(__('Invalid Operator Type'));
		}
		else
		{
			if ($this->OperatorType->delete()) {
				$this->Session->setFlash(__('Operator Type has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Operator Type could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
