<?php
App::uses('AppController', 'Controller');
class GroupThemesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('GroupTheme','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'GroupTheme.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->GroupTheme->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->GroupTheme->updateAll(array("GroupTheme.status"=>'0'),array("GroupTheme.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->GroupTheme->updateAll(array("GroupTheme.status"=>'1'),array("GroupTheme.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->GroupTheme->updateAll(array("GroupTheme.show_home"=>'1'),array("GroupTheme.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->GroupTheme->updateAll(array("GroupTheme.show_home"=>'0'),array("GroupTheme.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->GroupTheme->deleteAll(array('GroupTheme.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['GroupTheme']['title']) && $this->data['GroupTheme']['title']!='') $title = $this->data['GroupTheme']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['GroupTheme']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['GroupTheme.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('GroupTheme.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('group_themes', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add GroupTheme'));
		if ($this->request->is('post')) {
			$this->GroupTheme->create();	
			$pre_title_check = $this->GroupTheme->find("count",array("conditions"=>array("GroupTheme.title"=>$this->request->data['GroupTheme']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['GroupTheme']['date_time']			=	date("Y-m-d H:i:s");
				$theme_site_id=implode(",",$this->request->data['GroupTheme']['theme_site_id']);
				unset($this->request->data['GroupTheme']['theme_site_id']);
				$this->request->data['GroupTheme']['theme_site_id']=$theme_site_id;
				if ($res=$this->GroupTheme->save($this->request->data['GroupTheme'])){
					$this->Session->setFlash(__('Group Theme has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Group Theme could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Group Theme title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit GroupTheme'));
		$this->GroupTheme->id = $id;
		$selected = "";
		
		$driver_detail = $this->GroupTheme->find("first",array("conditions"=>array("GroupTheme.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->GroupTheme->exists()) {
			throw new NotFoundException(__('Invalid group_theme'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['GroupTheme']['id']=$id;	
			$theme_site_id=implode(",",$this->request->data['GroupTheme']['theme_site_id']);
			unset($this->request->data['GroupTheme']['theme_site_id']);
			$this->request->data['GroupTheme']['theme_site_id']=$theme_site_id;	
			$pre_title_check = $this->GroupTheme->find("count",array("conditions"=>array("GroupTheme.title"=>$this->request->data['GroupTheme']['title'],"GroupTheme.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->GroupTheme->saveAll($this->request->data['GroupTheme'])) {
					$this->Session->setFlash(__('Group Theme has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Group Theme could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Group Theme title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->GroupTheme->read(null, $id);
			$this->redirect(array('action' => 'index'));
		}
		$data= $this->GroupTheme->read(null, $id);
		$theme_site_id_arr=explode(",",$data['GroupTheme']['theme_site_id']);
		unset($data['GroupTheme']['theme_site_id']);
		$data['GroupTheme']['theme_site_id']=$theme_site_id_arr;
		$this->request->data = $data;
		
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->GroupTheme->id = $id;
		if (!$this->GroupTheme->exists()) {
			throw new NotFoundException(__('Invalid Group Theme'));
		}
		else
		{
			if ($this->GroupTheme->delete()) {
				$this->Session->setFlash(__('Group Theme has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Group Theme could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
