<?php
App::uses('AppController', 'Controller');
class AcceptSportsBettingsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('AcceptSportsBetting','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'AcceptSportsBetting.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->AcceptSportsBetting->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->AcceptSportsBetting->updateAll(array("AcceptSportsBetting.status"=>'0'),array("AcceptSportsBetting.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->AcceptSportsBetting->updateAll(array("AcceptSportsBetting.status"=>'1'),array("AcceptSportsBetting.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->AcceptSportsBetting->updateAll(array("AcceptSportsBetting.show_home"=>'1'),array("AcceptSportsBetting.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->AcceptSportsBetting->updateAll(array("AcceptSportsBetting.show_home"=>'0'),array("AcceptSportsBetting.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->AcceptSportsBetting->deleteAll(array('AcceptSportsBetting.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['AcceptSportsBetting']['title']) && $this->data['AcceptSportsBetting']['title']!='') $title = $this->data['AcceptSportsBetting']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['AcceptSportsBetting']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['AcceptSportsBetting.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('AcceptSportsBetting.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('accept_sports_bettings', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add AcceptSportsBetting'));
		if ($this->request->is('post')) {
			$this->AcceptSportsBetting->create();	
			$pre_title_check = $this->AcceptSportsBetting->find("count",array("conditions"=>array("AcceptSportsBetting.title"=>$this->request->data['AcceptSportsBetting']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['AcceptSportsBetting']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->AcceptSportsBetting->save($this->request->data['AcceptSportsBetting'])){
					$this->Session->setFlash(__('Accept Sports Betting has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Accept Sports Betting could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Accept Sports Betting title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit AcceptSportsBetting'));
		$this->AcceptSportsBetting->id = $id;
		$selected = "";
		
		$driver_detail = $this->AcceptSportsBetting->find("first",array("conditions"=>array("AcceptSportsBetting.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->AcceptSportsBetting->exists()) {
			throw new NotFoundException(__('Invalid accept_sports_betting'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['AcceptSportsBetting']['id']=$id;		
			$pre_title_check = $this->AcceptSportsBetting->find("count",array("conditions"=>array("AcceptSportsBetting.title"=>$this->request->data['AcceptSportsBetting']['title'],"AcceptSportsBetting.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->AcceptSportsBetting->saveAll($this->request->data['AcceptSportsBetting'])) {
					$this->Session->setFlash(__('Accept Sports Betting has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Accept Sports Betting could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Accept Sports Betting title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->AcceptSportsBetting->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->AcceptSportsBetting->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->AcceptSportsBetting->id = $id;
		if (!$this->AcceptSportsBetting->exists()) {
			throw new NotFoundException(__('Invalid Accept Sports Betting'));
		}
		else
		{
			if ($this->AcceptSportsBetting->delete()) {
				$this->Session->setFlash(__('Accept Sports Betting has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Accept Sports Betting could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
