<?php
App::uses('AppModel', 'Model');
class Site extends AppModel {
	var $name = 'Site';
	
	public $validate = array(
		 'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter name.',
			),
		),
		'url' => array(
			'url' => array(
			    'rule' => array('notempty'),
			    'message' => 'Please enter valid url.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checkurl',
					'url'
			     ) ,
			     'message' => 'URL is already in use.',
			),
		),
		
	);
	
	function _checkurl($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['Site.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['Site.url'] =  $this->data[$this->name][$field2];
		$user_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($user_count>0)
			return false;
		return true;
	}
}
