<?php
App::uses('AppController', 'Controller');
class WriterAvailabilitiesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('WriterAvailability','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'WriterAvailability.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->WriterAvailability->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->WriterAvailability->updateAll(array("WriterAvailability.status"=>'0'),array("WriterAvailability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->WriterAvailability->updateAll(array("WriterAvailability.status"=>'1'),array("WriterAvailability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->WriterAvailability->updateAll(array("WriterAvailability.show_home"=>'1'),array("WriterAvailability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->WriterAvailability->updateAll(array("WriterAvailability.show_home"=>'0'),array("WriterAvailability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->WriterAvailability->deleteAll(array('WriterAvailability.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['WriterAvailability']['title']) && $this->data['WriterAvailability']['title']!='') $title = $this->data['WriterAvailability']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['WriterAvailability']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['WriterAvailability.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('WriterAvailability.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('writer_availabilities', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add WriterAvailability'));
		if ($this->request->is('post')) {
			$this->WriterAvailability->create();	
			$pre_title_check = $this->WriterAvailability->find("count",array("conditions"=>array("WriterAvailability.title"=>$this->request->data['WriterAvailability']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['WriterAvailability']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->WriterAvailability->save($this->request->data['WriterAvailability'])){
					$this->Session->setFlash(__('Writer Availability has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Writer Availability could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Writer Availability title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit WriterAvailability'));
		$this->WriterAvailability->id = $id;
		$selected = "";
		
		$driver_detail = $this->WriterAvailability->find("first",array("conditions"=>array("WriterAvailability.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->WriterAvailability->exists()) {
			throw new NotFoundException(__('Invalid writer_availability'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['WriterAvailability']['id']=$id;		
			$pre_title_check = $this->WriterAvailability->find("count",array("conditions"=>array("WriterAvailability.title"=>$this->request->data['WriterAvailability']['title'],"WriterAvailability.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->WriterAvailability->saveAll($this->request->data['WriterAvailability'])) {
					$this->Session->setFlash(__('Writer Availability has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Writer Availability could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Writer Availability title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->WriterAvailability->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->WriterAvailability->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->WriterAvailability->id = $id;
		if (!$this->WriterAvailability->exists()) {
			throw new NotFoundException(__('Invalid Writer Availability'));
		}
		else
		{
			if ($this->WriterAvailability->delete()) {
				$this->Session->setFlash(__('Writer Availability has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Writer Availability could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
