<?php
App::uses('AppController', 'Controller');
class TempSitesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('TempSite','EmailTemplate','ApplicationSetting','Site'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'TempSite.id' => 'desc'
        )
    );
	public function beforeFilter() {
        parent::beforeFilter();
	}	
	public function admin_index($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->TempSite->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		if(isset($this->data['TempTempSite']['user_id']) && $this->data['TempTempSite']['user_id']!='') $user_id = $this->data['TempTempSite']['user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->data['TempTempSite']['user_id']=$this->params['named']['user_id'];
		
		if(isset($this->data['TempTempSite']['url']) && $this->data['TempTempSite']['url']!='') $url = $this->data['TempTempSite']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->data['TempTempSite']['url']=$this->params['named']['url'];
		
		if(isset($this->data['TempTempSite']['article_price_from']) && $this->data['TempTempSite']['article_price_from']!='') $article_price_from = $this->data['TempTempSite']['article_price_from'];	
		else if(isset($this->params['named']['article_price_from']) && $this->params['named']['article_price_from']!='') $article_price_from =$this->data['TempTempSite']['article_price_from']=$this->params['named']['article_price_from'];
		
		if(isset($this->data['TempTempSite']['article_price_to']) && $this->data['TempTempSite']['article_price_to']!='') $article_price_to = $this->data['TempTempSite']['article_price_to'];	
		else if(isset($this->params['named']['article_price_to']) && $this->params['named']['article_price_to']!='') $article_price_to = $this->data['TempTempSite']['article_price_to']=$this->params['named']['article_price_to'];
		
		if(isset($this->data['TempTempSite']['article_duration_id']) && $this->data['TempTempSite']['article_duration_id']!='') $article_duration_id = $this->data['TempTempSite']['article_duration_id'];	
		else if(isset($this->params['named']['article_duration_id']) && $this->params['named']['article_duration_id']!='') $article_duration_id = $this->data['TempTempSite']['article_duration_id']=$this->params['named']['article_duration_id'];
		
		if(isset($this->data['TempTempSite']['home_page_link_price_from']) && $this->data['TempTempSite']['home_page_link_price_from']!='') $home_page_link_price_from = $this->data['TempTempSite']['home_page_link_price_from'];	
		else if(isset($this->params['named']['home_page_link_price_from']) && $this->params['named']['home_page_link_price_from']!='') $home_page_link_price_from = $this->data['TempTempSite']['home_page_link_price_from']=$this->params['named']['home_page_link_price_from'];
		
		if(isset($this->data['TempTempSite']['home_page_link_price_to']) && $this->data['TempTempSite']['home_page_link_price_to']!='') $home_page_link_price_to = $this->data['TempTempSite']['home_page_link_price_to'];	
		else if(isset($this->params['named']['home_page_link_price_to']) && $this->params['named']['home_page_link_price_to']!='') $home_page_link_price_to = $this->data['TempTempSite']['home_page_link_price_to']=$this->params['named']['home_page_link_price_to'];
		if(isset($this->data['TempTempSite']['language_id']) && $this->data['TempTempSite']['language_id']!='') $language_id = $this->data['TempTempSite']['language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->data['TempTempSite']['language_id']=$this->params['named']['language_id'];
		
		if(isset($this->data['TempTempSite']['tf_id']) && $this->data['TempTempSite']['tf_id']!='') $tf_id = $this->data['TempTempSite']['tf_id'];	
		else if(isset($this->params['named']['tf_id']) && $this->params['named']['tf_id']!='') $tf_id = $this->data['TempTempSite']['tf_id']=$this->params['named']['tf_id'];
		
		if(isset($this->data['TempTempSite']['cf_id']) && $this->data['TempTempSite']['cf_id']!='') $cf_id = $this->data['TempTempSite']['cf_id'];	
		else if(isset($this->params['named']['cf_id']) && $this->params['named']['cf_id']!='') $cf_id = $this->data['TempTempSite']['cf_id']=$this->params['named']['cf_id'];
		
		if(isset($this->data['TempTempSite']['da_id']) && $this->data['TempTempSite']['da_id']!='') $da_id = $this->data['TempTempSite']['da_id'];	
		else if(isset($this->params['named']['da_id']) && $this->params['named']['da_id']!='') $da_id = $this->data['TempTempSite']['da_id']=$this->params['named']['da_id'];
		
		if(isset($this->data['TempTempSite']['provider_contact']) && $this->data['TempTempSite']['provider_contact']!='') $provider_contact = $this->data['TempTempSite']['provider_contact'];	
		else if(isset($this->params['named']['provider_contact']) && $this->params['named']['provider_contact']!='') $provider_contact = $this->data['TempTempSite']['provider_contact']=$this->params['named']['provider_contact'];
		
		if(isset($this->data['TempTempSite']['availability_id']) && $this->data['TempTempSite']['availability_id']!='') $availability_id = $this->data['TempTempSite']['availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->data['TempTempSite']['availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['TempTempSite']['type_site']) && $this->data['TempTempSite']['type_site']!='') $type_site = $this->data['TempTempSite']['type_site'];	
		else if(isset($this->params['named']['type_site']) && $this->params['named']['type_site']!='') $type_site = $this->data['TempTempSite']['type_site']=$this->params['named']['type_site'];
		
		if(isset($this->data['TempTempSite']['theme_site_id']) && $this->data['TempTempSite']['theme_site_id']!='') $theme_site_id = $this->data['TempTempSite']['theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->data['TempTempSite']['theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['TempTempSite']['gambling_site_id']) && $this->data['TempTempSite']['gambling_site_id']!='') $gambling_site_id = $this->data['TempTempSite']['gambling_site_id'];	
		else if(isset($this->params['named']['gambling_site_id']) && $this->params['named']['gambling_site_id']!='') $gambling_site_id = $this->data['TempTempSite']['gambling_site_id']=$this->params['named']['gambling_site_id'];
		
		if(isset($this->data['TempTempSite']['accept_gambling_id']) && $this->data['TempTempSite']['accept_gambling_id']!='') $accept_gambling_id = $this->data['TempTempSite']['accept_gambling_id'];	
		else if(isset($this->params['named']['accept_gambling_id']) && $this->params['named']['accept_gambling_id']!='') $accept_gambling_id = $this->data['TempTempSite']['accept_gambling_id']=$this->params['named']['accept_gambling_id'];
		
		if(isset($this->data['TempTempSite']['accept_sport_betting_id']) && $this->data['TempTempSite']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['TempTempSite']['accept_sport_betting_id'];	
		else if(isset($this->params['named']['accept_sport_betting_id']) && $this->params['named']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['TempTempSite']['accept_sport_betting_id']=$this->params['named']['accept_sport_betting_id'];
		
		if(isset($this->data['TempTempSite']['date_time_from']) && $this->data['TempTempSite']['date_time_from']!='') $date_time_from = $this->data['TempTempSite']['date_time_from'];	
		else if(isset($this->params['named']['date_time_from']) && $this->params['named']['date_time_from']!='') $date_time_from = $this->data['TempTempSite']['date_time_from']=$this->params['named']['date_time_from'];
				
		if(isset($this->data['TempTempSite']['date_time_to']) && $this->data['TempTempSite']['date_time_to']!='') $date_time_to = $this->data['TempTempSite']['date_time_to'];	
		else if(isset($this->params['named']['date_time_to']) && $this->params['named']['date_time_to']!='') $date_time_to = $this->data['TempTempSite']['date_time_to']=$this->params['named']['date_time_to'];
		
		if(isset($this->data['TempTempSite']['original_email_id']) && $this->data['TempTempSite']['original_email_id']!='') $original_email_id = $this->data['TempTempSite']['original_email_id'];	
		else if(isset($this->params['named']['original_email_id']) && $this->params['named']['original_email_id']!='') $original_email_id = $this->data['TempTempSite']['original_email_id']=$this->params['named']['original_email_id'];
		
		if(isset($this->data['TempTempSite']['employee_id']) && $this->data['TempTempSite']['employee_id']!='') $employee_id = $this->data['TempTempSite']['employee_id'];	
		else if(isset($this->params['named']['employee_id']) && $this->params['named']['employee_id']!='') $employee_id = $this->data['TempTempSite']['employee_id']=$this->params['named']['employee_id'];		
		
		if(isset($this->data['TempTempSite']['target_market_id']) && $this->data['TempTempSite']['target_market_id']!='') $target_market_id = $this->data['TempTempSite']['target_market_id'];	
		else if(isset($this->params['named']['target_market_id']) && $this->params['named']['target_market_id']!='') $target_market_id = $this->data['TempTempSite']['target_market_id']=$this->params['named']['target_market_id'];
		
		if(isset($this->data['TempTempSite']['limit']) && $this->data['TempSite']['limit']!='') $limit = $this->data['TempSite']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->data['TempTempSite']['limit']=$this->params['named']['limit'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		//echo '<pre>';print_r($this->data['TempSite']);
		if($this->Session->read('Auth.User.role') !=1)
			$conditions['TempSite.user_id']=$this->Auth->user('id');
		if(!empty($url))
		{
			$conditions['TempSite.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		if(!empty($article_price_from))
		{
			$conditions['TempSite.article_price >='] = $article_price_from;
			$pagingArgs['article_price_from'] = $article_price_from;
		}
		if(!empty($article_price_to))
		{
			$conditions['TempSite.article_price <='] = $article_price_to;
			$pagingArgs['article_price_to'] = $article_price_to;
		}
		if(!empty($article_duration_id))
		{
			$conditions['TempSite.article_duration_id'] = $article_duration_id;
			$pagingArgs['article_duration_id'] = $article_duration_id;
		}
		if(!empty($home_page_link_price_from))
		{
			$conditions['TempSite.home_page_link_price <='] = $home_page_link_price_from;
			$pagingArgs['home_page_link_price_from'] = $home_page_link_price_from;
		}
		if(!empty($home_page_link_price_to))
		{
			$conditions['TempSite.home_page_link_price >='] = $home_page_link_price_to;
			$pagingArgs['home_page_link_price_to'] = $home_page_link_price_to;
		}
		if(!empty($language_id))
		{
			$conditions['TempSite.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($tf_id))
		{
			$conditions['TempSite.tf_id'] = $tf_id;
			$pagingArgs['tf_id'] = $tf_id;
		}		
		if(!empty($cf_id))
		{
			$conditions['TempSite.cf_id'] = $cf_id;
			$pagingArgs['cf_id'] = $cf_id;
		}	
		if(!empty($da_id))
		{
			$conditions['TempSite.da_id'] = $da_id;
			$pagingArgs['da_id'] = $da_id;
		}
		if(!empty($provider_contact))
		{
			$conditions['TempSite.provider_contact LIKE '] = '%'.$provider_contact.'%';
			$pagingArgs['provider_contact'] = $provider_contact;
		}
		if(!empty($availability_id))
		{
			$conditions['TempSite.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($type_site))
		{
			$conditions['TempSite.type_site LIKE '] = '%'.$type_site.'%';
			$pagingArgs['type_site'] = $type_site;
		}
		if(!empty($theme_site_id))
		{
			$conditions['TempSite.theme_site_id'] = $theme_site_id;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['TempSite.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($accept_gambling_id))
		{
			$conditions['TempSite.accept_gambling_id'] = $accept_gambling_id;
			$pagingArgs['accept_gambling_id'] = $accept_gambling_id;
		}
		if(!empty($accept_sport_betting_id))
		{
			$conditions['TempSite.accept_sport_betting_id'] = $accept_sport_betting_id;
			$pagingArgs['accept_sport_betting_id'] = $accept_sport_betting_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['TempSite.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$conditions['TempSite.date_time >= '] = $date_time_from;
			$pagingArgs['date_time_from'] = $date_time_from;
		}
		if(!empty($date_time_to))
		{
			$conditions['TempSite.date_time <= '] = $date_time_to;
			$pagingArgs['date_time_to'] = $date_time_to;
		}
		if(!empty($original_email_id))
		{
			$conditions['TempSite.original_email_id'] = $original_email_id;
			$pagingArgs['original_email_id'] = $original_email_id;
		}
		if(!empty($employee_id))
		{
			$conditions['TempSite.employee_id'] = $employee_id;
			$pagingArgs['employee_id'] = $employee_id;
		}
		if(!empty($target_market_id))
		{
			$conditions['TempSite.target_market_id'] = $target_market_id;
			$pagingArgs['target_market_id'] = $target_market_id;
		}
		if(!empty($user_id))
		{
			$conditions['TempSite.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($fromdate))
		{
			$conditions['TempSite.date_time >= '] = $fromdate.' 00:00:00';
			$pagingArgs['fromdate'] = $fromdate;
		}
		if(!empty($todate))
		{
			$conditions['TempSite.date_time <= '] = $todate.' 23:59:59';
			$pagingArgs['todate'] = $todate;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
		//echo '<pre>';print_r($conditions);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('TempSite.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('sites', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "TempSite";
		if($id != null){
		$this->TempSite->id = $id;
		if (!$this->TempSite->exists()) {
			throw new NotFoundException(__('Invalid TempSite'));
		}
		}
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='Active')
			{
				foreach($this->request->data['frmList']['ID'] as $id)
				{
					$temp_site_data=$this->TempSite->find("first",array("TempSite.id"=>$id));
					$site_arr['Site']=$temp_site_data['TempSite'];
					$site_arr['Site']['id']=$site_arr['Site']['site_id'];
					unset($site_arr['Site']['site_id']);
					if ($res=$this->Site->save($site_arr)){	
						$this->TempSite->id = $id;
						$this->TempSite->delete();
					}
					
				}
				$this->Session->setFlash(__('Sites has been confirmed successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'temp_sites','action' => 'index'));
			}
			else if($this->request->data['task_value']=='Delete')
				$this->TempSite->deleteAll(array('TempSite.id' => $this->request->data['frmList']['ID']), false);
		}
	
	}
	public function admin_view($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Edit Temp Site'));
		$this->TempSite->id = $id;
		$selected = "";
		
		$driver_detail = $this->TempSite->find("first",array("conditions"=>array("TempSite.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->TempSite->exists()) {
			throw new NotFoundException(__('Invalid site'));
		}
		
		$pre_data= $this->TempSite->find("first",array("conditions"=>array("TempSite.id"=>$id)));
		$this->set('temp_sites', $pre_data);
		$pre_data_site= $this->Site->find("first",array("conditions"=>array("Site.id"=>$pre_data['TempSite']['site_id'])));
		$this->set('sites', $pre_data_site);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->TempSite->id = $id;
		if (!$this->TempSite->exists()) {
			throw new NotFoundException(__('Invalid site'));
		}
		else
		{
			if ($this->TempSite->delete()) {
				$this->Session->setFlash(__('Temp Site has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'temp_sites','action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Temp Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('controller'=>'temp_sites','action' => 'index'));
	}
	public function admin_confirm($id = null) {
		$this->checkAdmin();
		$this->TempSite->id = $id;
		if (!$this->TempSite->exists()) {
			throw new NotFoundException(__('Invalid site'));
		}
		else
		{
			$temp_site_data=$this->TempSite->find("first",array("TempSite.id"=>$id));
			
			$site_arr['Site']=$temp_site_data['TempSite'];
			$site_arr['Site']['id']=$site_arr['Site']['site_id'];
			unset($site_arr['Site']['site_id']);
			if ($res=$this->Site->save($site_arr)){	
				$this->TempSite->delete();
				$this->Session->setFlash(__('Site has been updated successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'temp_sites','action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Temp Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('controller'=>'temp_sites','action' => 'index'));
	}
}
