<?php
App::uses('AppController', 'Controller');
class MultipleKeywordsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('MultipleKeyword','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'MultipleKeyword.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->MultipleKeyword->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->MultipleKeyword->updateAll(array("MultipleKeyword.status"=>'0'),array("MultipleKeyword.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->MultipleKeyword->updateAll(array("MultipleKeyword.status"=>'1'),array("MultipleKeyword.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->MultipleKeyword->updateAll(array("MultipleKeyword.show_home"=>'1'),array("MultipleKeyword.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->MultipleKeyword->updateAll(array("MultipleKeyword.show_home"=>'0'),array("MultipleKeyword.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->MultipleKeyword->deleteAll(array('MultipleKeyword.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['MultipleKeyword']['title']) && $this->data['MultipleKeyword']['title']!='') $title = $this->data['MultipleKeyword']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['MultipleKeyword']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['MultipleKeyword.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('MultipleKeyword.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('multiple_keywords', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add MultipleKeyword'));
		if ($this->request->is('post')) {
			$this->MultipleKeyword->create();	
			$pre_title_check = $this->MultipleKeyword->find("count",array("conditions"=>array("MultipleKeyword.title"=>$this->request->data['MultipleKeyword']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['MultipleKeyword']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->MultipleKeyword->save($this->request->data['MultipleKeyword'])){
					$this->Session->setFlash(__('Multiple Keyword has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Multiple Keyword could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Multiple Keyword title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit MultipleKeyword'));
		$this->MultipleKeyword->id = $id;
		$selected = "";
		
		$driver_detail = $this->MultipleKeyword->find("first",array("conditions"=>array("MultipleKeyword.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->MultipleKeyword->exists()) {
			throw new NotFoundException(__('Invalid multiple keyword'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['MultipleKeyword']['id']=$id;		
			$pre_title_check = $this->MultipleKeyword->find("count",array("conditions"=>array("MultipleKeyword.title"=>$this->request->data['MultipleKeyword']['title'],"MultipleKeyword.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->MultipleKeyword->saveAll($this->request->data['MultipleKeyword'])) {
					$this->Session->setFlash(__('Multiple Keyword has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Multiple Keyword could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('MultipleKeyword title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->MultipleKeyword->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->MultipleKeyword->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->MultipleKeyword->id = $id;
		if (!$this->MultipleKeyword->exists()) {
			throw new NotFoundException(__('Invalid MultipleKeyword'));
		}
		else
		{
			if ($this->MultipleKeyword->delete()) {
				$this->Session->setFlash(__('Multiple Keyword has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Multiple Keyword could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
