<?php
App::uses('AppController', 'Controller');
class LinkStatusesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('LinkStatus','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'LinkStatus.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->LinkStatus->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->LinkStatus->updateAll(array("LinkStatus.status"=>'0'),array("LinkStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->LinkStatus->updateAll(array("LinkStatus.status"=>'1'),array("LinkStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->LinkStatus->updateAll(array("LinkStatus.show_home"=>'1'),array("LinkStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->LinkStatus->updateAll(array("LinkStatus.show_home"=>'0'),array("LinkStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->LinkStatus->deleteAll(array('LinkStatus.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['LinkStatus']['title']) && $this->data['LinkStatus']['title']!='') $title = $this->data['LinkStatus']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['LinkStatus']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['LinkStatus.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('LinkStatus.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('link_statuses', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add LinkStatus'));
		if ($this->request->is('post')) {
			$this->LinkStatus->create();	
			$pre_title_check = $this->LinkStatus->find("count",array("conditions"=>array("LinkStatus.title"=>$this->request->data['LinkStatus']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['LinkStatus']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->LinkStatus->save($this->request->data['LinkStatus'])){
					$this->Session->setFlash(__('Link Status has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Link Status could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Link Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit LinkStatus'));
		$this->LinkStatus->id = $id;
		$selected = "";
		
		$driver_detail = $this->LinkStatus->find("first",array("conditions"=>array("LinkStatus.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->LinkStatus->exists()) {
			throw new NotFoundException(__('Invalid link_status'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['LinkStatus']['id']=$id;		
			$pre_title_check = $this->LinkStatus->find("count",array("conditions"=>array("LinkStatus.title"=>$this->request->data['LinkStatus']['title'],"LinkStatus.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->LinkStatus->saveAll($this->request->data['LinkStatus'])) {
					$this->Session->setFlash(__('Link Status has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Link Status could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Link Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->LinkStatus->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->LinkStatus->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->LinkStatus->id = $id;
		if (!$this->LinkStatus->exists()) {
			throw new NotFoundException(__('Invalid Link Status'));
		}
		else
		{
			if ($this->LinkStatus->delete()) {
				$this->Session->setFlash(__('Link Status has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Link Status could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
