<?php
App::uses('AppController', 'Controller');
class ErrorTypesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ErrorType','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ErrorType.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ErrorType->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->ErrorType->updateAll(array("ErrorType.status"=>'0'),array("ErrorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->ErrorType->updateAll(array("ErrorType.status"=>'1'),array("ErrorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->ErrorType->updateAll(array("ErrorType.show_home"=>'1'),array("ErrorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->ErrorType->updateAll(array("ErrorType.show_home"=>'0'),array("ErrorType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->ErrorType->deleteAll(array('ErrorType.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['ErrorType']['title']) && $this->data['ErrorType']['title']!='') $title = $this->data['ErrorType']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['ErrorType']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['ErrorType.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ErrorType.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('error_types', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add ErrorType'));
		if ($this->request->is('post')) {
			$this->ErrorType->create();	
			$pre_title_check = $this->ErrorType->find("count",array("conditions"=>array("ErrorType.title"=>$this->request->data['ErrorType']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['ErrorType']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->ErrorType->save($this->request->data['ErrorType'])){
					$this->Session->setFlash(__('Error Type has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Error Type could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Error Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit ErrorType'));
		$this->ErrorType->id = $id;
		$selected = "";
		
		$driver_detail = $this->ErrorType->find("first",array("conditions"=>array("ErrorType.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->ErrorType->exists()) {
			throw new NotFoundException(__('Invalid error_type'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['ErrorType']['id']=$id;		
			$pre_title_check = $this->ErrorType->find("count",array("conditions"=>array("ErrorType.title"=>$this->request->data['ErrorType']['title'],"ErrorType.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->ErrorType->saveAll($this->request->data['ErrorType'])) {
					$this->Session->setFlash(__('Error Type has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Error Type could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Error Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->ErrorType->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->ErrorType->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ErrorType->id = $id;
		if (!$this->ErrorType->exists()) {
			throw new NotFoundException(__('Invalid Error Type'));
		}
		else
		{
			if ($this->ErrorType->delete()) {
				$this->Session->setFlash(__('Error Type has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Error Type could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
