<?php
App::uses('AppController', 'Controller');
class CurrenciesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Currency','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Currency.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->Currency->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->Currency->updateAll(array("Currency.status"=>'0'),array("Currency.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->Currency->updateAll(array("Currency.status"=>'1'),array("Currency.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->Currency->updateAll(array("Currency.show_home"=>'1'),array("Currency.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->Currency->updateAll(array("Currency.show_home"=>'0'),array("Currency.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->Currency->deleteAll(array('Currency.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Currency']['title']) && $this->data['Currency']['title']!='') $title = $this->data['Currency']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['Currency']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['Currency.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Currency.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('currencies', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add Currency'));
		if ($this->request->is('post')) {
			$this->Currency->create();	
			$pre_title_check = $this->Currency->find("count",array("conditions"=>array("Currency.title"=>$this->request->data['Currency']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['Currency']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->Currency->save($this->request->data['Currency'])){
					$this->Session->setFlash(__('Currency has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Currency could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Currency title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit Currency'));
		$this->Currency->id = $id;
		$selected = "";
		
		$driver_detail = $this->Currency->find("first",array("conditions"=>array("Currency.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->Currency->exists()) {
			throw new NotFoundException(__('Invalid currency'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['Currency']['id']=$id;		
			$pre_title_check = $this->Currency->find("count",array("conditions"=>array("Currency.title"=>$this->request->data['Currency']['title'],"Currency.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->Currency->saveAll($this->request->data['Currency'])) {
					$this->Session->setFlash(__('Currency has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Currency could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Currency title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->Currency->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->Currency->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->Currency->id = $id;
		if (!$this->Currency->exists()) {
			throw new NotFoundException(__('Invalid Currency'));
		}
		else
		{
			if ($this->Currency->delete()) {
				$this->Session->setFlash(__('Currency has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Currency could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
