<?php
App::uses('AppController', 'Controller');
class ContactWaysController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ContactWay','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ContactWay.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ContactWay->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->ContactWay->updateAll(array("ContactWay.status"=>'0'),array("ContactWay.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->ContactWay->updateAll(array("ContactWay.status"=>'1'),array("ContactWay.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->ContactWay->updateAll(array("ContactWay.show_home"=>'1'),array("ContactWay.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->ContactWay->updateAll(array("ContactWay.show_home"=>'0'),array("ContactWay.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->ContactWay->deleteAll(array('ContactWay.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['ContactWay']['title']) && $this->data['ContactWay']['title']!='') $title = $this->data['ContactWay']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['ContactWay']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['ContactWay.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ContactWay.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('contact_ways', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add ContactWay'));
		if ($this->request->is('post')) {
			$this->ContactWay->create();	
			$pre_title_check = $this->ContactWay->find("count",array("conditions"=>array("ContactWay.title"=>$this->request->data['ContactWay']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['ContactWay']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->ContactWay->save($this->request->data['ContactWay'])){
					$this->Session->setFlash(__('Contact Way has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Contact Way could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Contact Way title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit ContactWay'));
		$this->ContactWay->id = $id;
		$selected = "";
		
		$driver_detail = $this->ContactWay->find("first",array("conditions"=>array("ContactWay.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->ContactWay->exists()) {
			throw new NotFoundException(__('Invalid contact_way'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['ContactWay']['id']=$id;		
			$pre_title_check = $this->ContactWay->find("count",array("conditions"=>array("ContactWay.title"=>$this->request->data['ContactWay']['title'],"ContactWay.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->ContactWay->saveAll($this->request->data['ContactWay'])) {
					$this->Session->setFlash(__('Contact Way has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Contact Way could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Contact Way title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->ContactWay->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->ContactWay->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ContactWay->id = $id;
		if (!$this->ContactWay->exists()) {
			throw new NotFoundException(__('Invalid Contact Way'));
		}
		else
		{
			if ($this->ContactWay->delete()) {
				$this->Session->setFlash(__('Contact Way has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Contact Way could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
