<?php
App::uses('AppController', 'Controller');
class AvailabilitiesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Availability','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Availability.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->Availability->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->Availability->updateAll(array("Availability.status"=>'0'),array("Availability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->Availability->updateAll(array("Availability.status"=>'1'),array("Availability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->Availability->updateAll(array("Availability.show_home"=>'1'),array("Availability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->Availability->updateAll(array("Availability.show_home"=>'0'),array("Availability.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->Availability->deleteAll(array('Availability.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Availability']['title']) && $this->data['Availability']['title']!='') $title = $this->data['Availability']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['Availability']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['Availability.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Availability.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('availabilities', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add Availability'));
		if ($this->request->is('post')) {
			$this->Availability->create();	
			$pre_title_check = $this->Availability->find("count",array("conditions"=>array("Availability.title"=>$this->request->data['Availability']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['Availability']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->Availability->save($this->request->data['Availability'])){
					$this->Session->setFlash(__('Availability has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Availability could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Availability title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit Availability'));
		$this->Availability->id = $id;
		$selected = "";
		
		$driver_detail = $this->Availability->find("first",array("conditions"=>array("Availability.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->Availability->exists()) {
			throw new NotFoundException(__('Invalid availability'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['Availability']['id']=$id;		
			$pre_title_check = $this->Availability->find("count",array("conditions"=>array("Availability.title"=>$this->request->data['Availability']['title'],"Availability.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->Availability->saveAll($this->request->data['Availability'])) {
					$this->Session->setFlash(__('Availability has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Availability could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Availability title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->Availability->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->Availability->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->Availability->id = $id;
		if (!$this->Availability->exists()) {
			throw new NotFoundException(__('Invalid Availability'));
		}
		else
		{
			if ($this->Availability->delete()) {
				$this->Session->setFlash(__('Availability has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Availability could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
